/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.floatingBlock;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamport.aether.blocks.AetherBlocks;

public class EntityFloatingBlock
extends Entity {
    public CarriedBlock carriedBlock;
    public int floatTime;
    public boolean hasRemovedBlock = false;

    public EntityFloatingBlock(World world) {
        super(world);
        this.carriedBlock = new CarriedBlock((Entity)this, AetherBlocks.ORE_GRAVITITE_HOLYSTONE, 0, null);
        this.floatTime = 0;
        this.setSize(1.0f, 1.0f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    public EntityFloatingBlock(World world, double x, double y, double z, int blockId, int blockMeta, @Nullable TileEntity tileEntity) {
        super(world);
        this.carriedBlock = new CarriedBlock((Entity)this, blockId, blockMeta, tileEntity);
        if (tileEntity != null) {
            tileEntity.worldObj = null;
            tileEntity.carriedBlock = this.carriedBlock;
        }
        this.floatTime = 0;
        this.blocksBuilding = true;
        this.setSize(1.0f, 1.0f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x, y, z);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected boolean makeStepSound() {
        return false;
    }

    protected void defineSynchedData() {
    }

    public boolean isPickable() {
        return !this.removed;
    }

    public void tick() {
        double v;
        boolean hitCeiling;
        if (this.carriedBlock.blockId == 0) {
            this.remove();
            return;
        }
        this.pushesThisTick = 0;
        this.pushTime *= 0.98f;
        if (this.pushTime < 0.05f || (double)this.pushTime < 0.25 && this.onGround) {
            this.pushTime = 0.0f;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if ((double)this.pushTime < 0.01 && this.yd >= 0.0) {
            ++this.floatTime;
        }
        this.yd += 0.04;
        double oldYd = this.yd;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        int x = MathHelper.round((double)(this.x - 0.5));
        int y = MathHelper.round((double)this.y);
        int z = MathHelper.round((double)(this.z - 0.5));
        if (this.world.getBlockId(x, y, z) == this.carriedBlock.blockId && !this.hasRemovedBlock) {
            this.world.setBlockWithNotify(x, y, z, 0);
            this.hasRemovedBlock = true;
        }
        if (this.y > 256.0) {
            this.remove();
            return;
        }
        boolean bl = hitCeiling = this.verticalCollision && oldYd > 0.0;
        if (hitCeiling) {
            Block selfBlock = this.carriedBlock.block();
            Block blockAbove = this.world.getBlock(x, y + 1, z);
            double friction = selfBlock.friction;
            this.xd *= (friction *= blockAbove == null ? 0.98 : (double)(blockAbove.friction * 0.91f));
            this.zd *= friction;
            this.yd *= -0.5;
            this.pushTime *= (float)friction;
        }
        if ((v = Math.hypot(this.xd, this.zd)) < 0.001 || this.isInWall()) {
            if (!hitCeiling && !this.isInWall()) {
                if (this.floatTime > 600 && !this.world.isClientSide) {
                    this.drop();
                    this.remove();
                }
            } else {
                this.remove();
                if (!this.world.isClientSide) {
                    boolean shouldDrop;
                    boolean bl2 = shouldDrop = !this.world.canBlockBePlacedAt(this.carriedBlock.blockId, x, y, z, true, Side.TOP) || !this.world.setBlock(x, y, z, this.carriedBlock.blockId);
                    if (shouldDrop) {
                        if (this.hasRemovedBlock) {
                            this.drop();
                        }
                    } else {
                        this.world.setBlockMetadata(x, y, z, this.carriedBlock.metadata);
                        if (this.carriedBlock.entity != null) {
                            TileEntity oldEnt = this.world.getTileEntity(x, y, z);
                            if (oldEnt != null) {
                                oldEnt.invalidate();
                            }
                            this.carriedBlock.entity.validate();
                            this.carriedBlock.entity.x = x;
                            this.carriedBlock.entity.y = y;
                            this.carriedBlock.entity.z = z;
                            this.carriedBlock.entity.worldObj = this.world;
                            this.carriedBlock.entity.carriedBlock = null;
                            this.world.replaceBlockTileEntity(x, y, z, this.carriedBlock.entity);
                        }
                        this.world.notifyBlockChange(x, y, z, this.carriedBlock.blockId);
                    }
                }
            }
            this.carriedBlock.heldTick(this.world, (Entity)this);
        }
    }

    public void drop() {
        int i;
        ItemStack[] drops;
        Block block = this.carriedBlock.block();
        if (block != null && (drops = block.getBreakResult(this.world, EnumDropCause.SILK_TOUCH, this.carriedBlock.metadata, this.carriedBlock.entity)) != null && drops.length > 0) {
            for (i = 0; i < drops.length; ++i) {
                this.dropItem(drops[i], 0.0f);
            }
        }
        if (this.carriedBlock.entity != null) {
            int x = MathHelper.round((double)(this.x - 0.5));
            i = MathHelper.round((double)this.y);
            int z = MathHelper.round((double)(this.z - 0.5));
            this.carriedBlock.entity.dropContents(this.world, x, i, z);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putShort("Tile", (short)this.carriedBlock.blockId);
        tag.putShort("TileData", (short)this.carriedBlock.metadata);
        if (this.carriedBlock.entity != null) {
            CompoundTag entityTag = new CompoundTag();
            this.carriedBlock.entity.writeToNBT(entityTag);
            tag.putCompound("TileEntity", entityTag);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        this.carriedBlock = new CarriedBlock((Entity)this, tag.getShort("Tile") & 0x3FFF, tag.getShort("TileData") & 0xFF, tag.containsKey("TileEntity") ? TileEntityDispatcher.createAndLoadEntity((CompoundTag)tag.getCompound("TileEntity")) : null);
    }

    public void fling(double xd, double yd, double zd, float pushTime) {
        super.fling(xd, yd, zd, pushTime);
        this.floatTime = 0;
    }

    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public boolean showBoundingBoxOnHover() {
        return true;
    }

    public double getRideHeight() {
        return 0.0;
    }
}

