/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.zephyr;

import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.MobFlying;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import teamport.aether.blocks.AetherBlockTags;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.projectile.ProjectileWindball;
import teamport.aether.items.accessory.AetherInvisibility;

public class MobZephyr
extends MobFlying
implements Enemy,
AetherDeathMessage {
    public int courseChangeCooldown = 0;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    public Entity targetedEntity = null;
    public int aggroCooldown = 0;
    public int attackChargeO = 0;
    public int attackCharge = 0;

    public MobZephyr(World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"zephyr");
        this.setSize(5.0f, 4.0f);
        this.scoreValue = 500;
        this.mobDrops.add(new WeightedRandomLootObject(AetherBlocks.AERCLOUD_WHITE.getDefaultStack(), 0, 6));
    }

    public int getMaxHealth() {
        return 10;
    }

    public void defineSynchedData() {
        this.entityData.define(16, (Object)0, Byte.class);
    }

    public String getEntityTexture() {
        return this.entityData.getByte(16) != 1 ? super.getEntityTexture() : "/assets/aether/textures/entity/zephyr_fire/" + this.getTextureReference() + ".png";
    }

    @NotNull
    public String getDefaultEntityTexture() {
        return this.entityData.getByte(16) != 1 ? super.getEntityTexture() : "/assets/aether/textures/entity/zephyr_fire/0.png";
    }

    public void tick() {
        if (this.world.isClientSide) {
            byte i = this.entityData.getByte(16);
            if (i > 0 && this.attackCharge == 0) {
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.zephyr.shoot", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.attackCharge += i;
            if (this.attackCharge < 0) {
                this.attackCharge = 0;
            }
            if (this.attackCharge >= 20) {
                this.attackCharge = 20;
            }
            if (this.attackCharge == 20 && i == 0) {
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.zephyr.shoot", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.attackCharge = -40;
            }
        }
        super.tick();
    }

    public void updateAI() {
        byte chargeState;
        byte chargeData;
        if (!this.world.isClientSide && !this.world.getDifficulty().canHostileMobsSpawn()) {
            this.remove();
        }
        if (this.y < -2.0 || this.y > 256.0) {
            this.remove();
        }
        this.tryToDespawn();
        this.attackChargeO = this.attackCharge;
        double d = this.waypointX - this.x;
        double d1 = this.waypointY - this.y;
        double d2 = this.waypointZ - this.z;
        double d3 = MathHelper.sqrt((double)(d * d + d1 * d1 + d2 * d2));
        if (d3 < 1.0 || d3 > 60.0) {
            this.waypointX = this.x + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointY = this.y + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointZ = this.z + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.random.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3)) {
                this.xd += d / d3 * 0.1;
                this.yd += d1 / d3 * 0.1;
                this.zd += d2 / d3 * 0.1;
            } else {
                this.waypointX = this.x;
                this.waypointY = this.y;
                this.waypointZ = this.z;
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.removed) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = this.findPlayerToAttack();
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
            if (this.targetedEntity != null && !((Player)this.targetedEntity).getGamemode().areMobsHostile()) {
                this.targetedEntity = null;
            }
        }
        double d4 = 64.0;
        if (this.targetedEntity != null && this.targetedEntity.distanceToSqr((Entity)this) < d4 * d4) {
            double d8 = 4.0;
            Vec3 vec3 = this.getViewVector(1.0f);
            double dX = this.targetedEntity.x - this.x;
            double dY = this.targetedEntity.y - this.y;
            double dZ = this.targetedEntity.z - this.z;
            double dist = MathHelper.sqrt((double)(dX * dX + dY * dY + dZ * dZ));
            double vX = dX + this.targetedEntity.xd * dist / 7.5 - vec3.x * d8;
            double vY = dY + this.targetedEntity.yd * dist / 7.5 - ((double)(this.bbHeight / 2.0f) + 0.5);
            double vZ = dZ + this.targetedEntity.zd * dist / 7.5 - vec3.z * d8;
            this.yBodyRot = this.yRot = -((float)Math.atan2(vX, vZ)) * 180.0f / (float)Math.PI;
            if (this.canEntityBeSeen(this.targetedEntity)) {
                if (this.attackCharge == 10) {
                    this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.zephyr.call", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                ++this.attackCharge;
                if (this.attackCharge == 20) {
                    this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.zephyr.shoot", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    ProjectileWindball windball = new ProjectileWindball(this.world, (Mob)this, vX, vY, vZ);
                    windball.setPos(this.x + vec3.x * d8, this.y + (double)(this.bbHeight / 2.0f) - 0.5, this.z + vec3.z * d8);
                    this.world.entityJoinedWorld((Entity)windball);
                    this.attackCharge = -40;
                }
            } else if (this.attackCharge > 0) {
                --this.attackCharge;
            } else {
                this.targetedEntity = null;
            }
        } else {
            this.yBodyRot = this.yRot = -((float)Math.atan2(this.xd, this.zd)) * 180.0f / (float)Math.PI;
            if (this.attackCharge > 0) {
                --this.attackCharge;
            }
        }
        if (!this.world.isClientSide && (chargeData = this.entityData.getByte(16)) != (chargeState = (byte)(this.attackCharge > 10 ? 1 : 0))) {
            this.entityData.set(16, (Object)chargeState);
        }
    }

    private Entity findPlayerToAttack() {
        AetherInvisibility invPlayer;
        Player player = this.world.getClosestPlayerToEntity((Entity)this, 100.0);
        if (player == null || !this.canEntityBeSeen((Entity)player) || !player.getGamemode().areMobsHostile()) {
            return null;
        }
        if (player instanceof AetherInvisibility && (invPlayer = (AetherInvisibility)player).aether$isInvisible()) {
            Player newPlayer = this.world.getClosestPlayerToEntity((Entity)this, 2.0);
            if (newPlayer == null || !this.canEntityBeSeen((Entity)newPlayer) || !newPlayer.getGamemode().areMobsHostile()) {
                return null;
            }
            return newPlayer;
        }
        return player;
    }

    public boolean isCourseTraversable(double d, double d1, double d2, double d3) {
        double d4 = (this.waypointX - this.x) / d3;
        double d5 = (this.waypointY - this.y) / d3;
        double d6 = (this.waypointZ - this.z) / d3;
        AABB axisalignedbb = this.bb.copy();
        int i = 1;
        while ((double)i < d3) {
            axisalignedbb.move(d4, d5, d6);
            if (!this.world.getCubes((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (super.hurt(attacker, i, type)) {
            if (this.passenger != attacker && this.vehicle != attacker && attacker != this) {
                this.targetedEntity = attacker;
                this.aggroCooldown = 60;
            }
            return true;
        }
        return false;
    }

    public String getLivingSound() {
        return "aether:mob.zephyr.call";
    }

    public String getHurtSound() {
        return "aether:mob.zephyr.call";
    }

    public String getDeathSound() {
        return "aether:mob.zephyr.call";
    }

    public float getSoundVolume() {
        return 3.0f;
    }

    public boolean canSpawnHere() {
        boolean tooManyZephyrs;
        int x = MathHelper.floor((double)this.x);
        int y = MathHelper.floor((double)this.bb.minY);
        int z = MathHelper.floor((double)this.z);
        boolean bl = tooManyZephyrs = this.world.loadedEntityList.stream().filter(e -> e instanceof MobZephyr).filter(e -> e.distanceTo((Entity)this) <= 32.0f).count() > 5L;
        if (tooManyZephyrs) {
            return false;
        }
        return this.world.getDifficulty().canHostileMobsSpawn() && this.random.nextInt(10) == 0 && AetherBlockTags.PASSIVE_MOBS_SPAWN.appliesTo((ITaggable)this.world.getBlock(MathHelper.floor((double)this.x), MathHelper.floor((double)(this.y - (double)this.heightOffset)) - 1, MathHelper.floor((double)this.z))) && super.canSpawnHere() && this.world.getSavedLightValue(LightLayer.Block, x, y, z) < 7;
    }

    public void spawnInit() {
        if (this.world.getBlockId((int)(this.x + 0.5), (int)(this.y + 15.0), (int)(this.z + 0.5)) == 0) {
            this.moveTo(this.x, this.y + 15.0, this.z, this.yRot, 0.0f);
        }
    }

    public int getMaxSpawnedInChunk() {
        return 1;
    }
}

