/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamport.aether.entity.projectile.ProjectileAether;
import teamport.aether.helper.ParticleMaker;

public abstract class ProjectileElementBase
extends Projectile
implements ProjectileAether {
    public int bounceCount = 0;
    public int maxBounces = 20;
    public String[] particles = new String[]{"explode"};

    public ProjectileElementBase(World world) {
        super(world);
        this.initProjectile();
    }

    public ProjectileElementBase(World world, Mob owner) {
        super(world, owner);
        this.initProjectile();
    }

    public ProjectileElementBase(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.initProjectile();
    }

    public void initProjectile() {
        this.damage = 2;
        this.defaultGravity = 0.0f;
        this.setSize(1.0f, 1.0f);
    }

    public void tick() {
        super.tick();
        int xFloor = MathHelper.floor((double)this.x);
        int yFloor = MathHelper.floor((double)this.y);
        int zFloor = MathHelper.floor((double)this.z);
        if (this.xd > 0.0 && this.world.getBlockId(xFloor + 1, yFloor, zFloor) != 0) {
            this.xd = -this.xd;
            this.bounceSound();
            ++this.bounceCount;
        } else if (this.xd < 0.0 && this.world.getBlockId(xFloor - 1, yFloor, zFloor) != 0) {
            this.xd = -this.xd;
            this.bounceSound();
            ++this.bounceCount;
        }
        if (this.yd > 0.0 && this.world.getBlockId(xFloor, yFloor + 1, zFloor) != 0) {
            this.yd = -this.yd;
            this.bounceSound();
            ++this.bounceCount;
        } else if (this.yd < 0.0 && this.world.getBlockId(xFloor, yFloor - 1, zFloor) != 0) {
            this.yd = -this.yd;
            this.bounceSound();
            ++this.bounceCount;
        }
        if (this.zd > 0.0 && this.world.getBlockId(xFloor, yFloor, zFloor + 1) != 0) {
            this.zd = -this.zd;
            this.bounceSound();
            ++this.bounceCount;
        } else if (this.zd < 0.0 && this.world.getBlockId(xFloor, yFloor, zFloor - 1) != 0) {
            this.zd = -this.zd;
            this.bounceSound();
            ++this.bounceCount;
        }
        if (!this.world.isClientSide && this.bounceCount >= this.maxBounces) {
            this.doExplosion();
            this.remove();
        }
    }

    public void bounceSound() {
        this.world.playSoundAtEntity(null, (Entity)this, "random.explode", 0.1f, 2.0f);
    }

    public void doExplosion() {
        for (int particle = 0; particle < 16; ++particle) {
            double XParticle = this.x + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            double YParticle = this.y + 0.5 + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            double ZParticle = this.z + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            ParticleMaker.spawnParticle(this.world, this.particles[this.world.rand.nextInt(this.particles.length)], XParticle, YParticle, ZParticle, 0.0, 0.0, 0.0, 0);
        }
        this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, this.x, this.y, this.z, "random.explode", 0.25f, (1.3f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f);
    }

    public void onHit(HitResult hitResult) {
        if (!this.world.isClientSide && hitResult.side != null) {
            switch (hitResult.side) {
                case BOTTOM: 
                case TOP: {
                    this.yd = -this.yd * 1.0;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.zd = -this.zd * 1.0;
                    break;
                }
                case WEST: 
                case EAST: {
                    this.xd = -this.xd * 1.0;
                }
            }
            ++this.bounceCount;
        }
    }

    public void afterTick() {
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        if (this.isInWater()) {
            this.waterTick();
        }
        this.setPos(this.x, this.y, this.z);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.bounceCount = tag.getInteger("bounceCount");
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("bounceCount", this.bounceCount);
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean hurt(Entity entity, int damage, DamageType type) {
        return false;
    }

    protected static Entity getEntity(Class<? extends ProjectileElementBase> clazz, World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner, @Nullable CompoundTag compoundTag) {
        ProjectileElementBase element;
        try {
            element = clazz.getDeclaredConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        element.setPos(x, y, z);
        if (hasVelocity) {
            element.setHeading(xd, yd, zd, 1.0f, 0.0f);
        }
        if (owner instanceof Mob) {
            element.owner = (Mob)owner;
        }
        return element;
    }
}

