/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import com.mojang.nbt.tags.CompoundTag;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.AetherMod;
import teamport.aether.entity.boss.valkyrie.queen.MobBossValkyrie;
import teamport.aether.entity.projectile.AetherProjectileDeathMessages;
import teamport.aether.entity.projectile.ProjectileElementBase;
import teamport.aether.helper.ParticleMaker;

public class ProjectileElementLightning
extends ProjectileElementBase
implements AetherProjectileDeathMessages<ProjectileElementLightning> {
    public String[] particles = new String[]{"explode", "lightning", "lightning"};
    private Mob target;
    private static final float homingPower = 0.15f;
    private static final float topSpeed = 0.5f;

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner, @Nullable CompoundTag compoundTag) {
        return ProjectileElementLightning.getEntity(ProjectileElementLightning.class, world, x, y, z, meta, hasVelocity, xd, yd, zd, owner, compoundTag);
    }

    public ProjectileElementLightning(World world) {
        super(world);
        this.initProjectile();
    }

    public ProjectileElementLightning(World world, Mob owner) {
        super(world, owner);
        this.initProjectile();
    }

    @Override
    public void initProjectile() {
        super.initProjectile();
        this.damage = 4;
        this.defaultGravity = 0.0f;
        this.defaultProjectileSpeed = 1.0f;
        this.setSize(1.0f, 1.0f);
    }

    @Override
    public void doExplosion() {
        for (int particle = 0; particle < 16; ++particle) {
            double XParticle = this.target.x + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            double YParticle = this.target.y - 1.0 + 0.5 + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            double ZParticle = this.target.z + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            ParticleMaker.spawnParticle(this.world, this.particles[this.world.rand.nextInt(this.particles.length)], XParticle, YParticle, ZParticle, 0.0, 0.0, 0.0, 0);
        }
        this.world.playSoundEffect((Entity)this.target, SoundCategory.ENTITY_SOUNDS, this.target.x, this.target.y - 1.0, this.target.z, "aether:zap", 0.5f, (1.3f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public void tick() {
        double dz;
        double dy;
        double dx;
        double dist;
        for (int j = 0; j < 2; ++j) {
            ParticleMaker.spawnParticle(this.world, "lightning", this.x, this.y + 0.5, this.z, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), this.world.rand.nextFloat() * 0.25f * -1.0f, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), 0);
        }
        ++this.ticksInAir;
        if (this.ticksInAir > 100) {
            this.remove();
            ParticleMaker.spawnParticle(this.world, "explode", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
            ParticleMaker.spawnParticle(this.world, "smoke", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
            ParticleMaker.spawnParticle(this.world, "largesmoke", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
            this.world.playSoundAtEntity(null, (Entity)this, "mob.ghast.fireball", 1.0f, this.random.nextFloat() * 1.4f + 1.8f);
        }
        if (this.target == null || !this.target.isAlive()) {
            AABB searchBox = AABB.getPermanentBB((double)(this.x - 16.0), (double)(this.y - 16.0), (double)(this.z - 16.0), (double)(this.x + 16.0), (double)(this.y + 16.0), (double)(this.z + 16.0));
            List entities = this.world.getEntitiesWithinAABB(Mob.class, searchBox);
            Player closestPlayer = null;
            for (Mob entity : entities) {
                double distance;
                if (!(entity instanceof Player) || !entity.isAlive() || !((distance = (double)this.distanceTo((Entity)entity)) < 32.0)) continue;
                closestPlayer = (Player)entity;
            }
            this.target = closestPlayer;
        }
        if (this.target != null && this.target.isAlive() && (dist = Math.sqrt((dx = this.target.x - this.x) * dx + (dy = this.target.y + (double)this.target.getHeadHeight() - this.y) * dy + (dz = this.target.z - this.z) * dz)) > 0.0) {
            double targetXd = dx / dist * 0.5;
            double targetYd = dy / dist * 0.5;
            double targetZd = dz / dist * 0.5;
            this.xd += (targetXd - this.xd) * (double)0.15f;
            this.yd += (targetYd - this.yd) * (double)0.15f;
            this.zd += (targetZd - this.zd) * (double)0.15f;
            double speed = Math.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
            if (speed > 0.5) {
                this.xd = this.xd / speed * 0.5;
                this.yd = this.yd / speed * 0.5;
                this.zd = this.zd / speed * 0.5;
            }
        }
        super.tick();
    }

    @Override
    public void onHit(HitResult hitResult) {
        if (!(this.world.isClientSide || hitResult.entity instanceof MobBossValkyrie || hitResult.entity instanceof ProjectileElementBase)) {
            if (hitResult.entity instanceof MobCreeper || hitResult.entity instanceof MobPig) {
                EntityLightning bolt = new EntityLightning(this.world, this.x, this.y, this.z);
                this.world.entityJoinedWorld((Entity)bolt);
                this.remove();
                this.doExplosion();
                return;
            }
            if (hitResult.entity instanceof Mob) {
                hitResult.entity.hurt((Entity)this.owner, this.damage, AetherMod.LIGHTNING);
                this.remove();
                this.doExplosion();
                return;
            }
        }
        super.onHit(hitResult);
    }
}

