/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.helper;

import java.util.Random;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketAddParticle;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.net.PlayerList;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class ParticleMaker {
    public static Random random = new Random();

    public static void spawnParticle(World world, String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data, double maxDistance) {
        if (EnvironmentHelper.isClientWorld()) {
            return;
        }
        if (EnvironmentHelper.isServerEnvironment()) {
            PlayerList playerList = MinecraftServer.getInstance().playerList;
            playerList.sendPacketToAllPlayersInDimension((Packet)new PacketAddParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, maxDistance), world.dimension.id);
            return;
        }
        world.spawnParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, maxDistance);
    }

    public static void spawnParticle(World world, String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
        ParticleMaker.spawnParticle(world, particleKey, x, y, z, motionX, motionY, motionZ, data, 16.0);
    }

    public static void spawnCloudParticles(World world, double x, double y, double z, double bbHeight) {
        float width = 1.0f;
        for (int i = 0; i < 20; ++i) {
            double dx = random.nextGaussian() * 0.02;
            double dy = random.nextGaussian() * 0.02;
            double dz = random.nextGaussian() * 0.02;
            ParticleMaker.spawnParticle(world, "snowshovel", x + (double)(random.nextFloat() * width * 2.0f) - (double)width, y - bbHeight + (double)(random.nextFloat() * width), z + (double)(random.nextFloat() * width * 2.0f) - (double)width, dx, dy, dz, 0);
        }
    }

    public static void spawnSmokeParticles(World world, double x, double y, double z, double bbHeight, double bbWidth) {
        double dx = random.nextGaussian() * 0.02;
        double dy = random.nextGaussian() * 0.02;
        double dz = random.nextGaussian() * 0.02;
        ParticleMaker.spawnParticle(world, "smoke", x + (double)random.nextFloat() * bbWidth * 2.0 - bbWidth, y + (double)random.nextFloat() * bbHeight - bbHeight, z + (double)random.nextFloat() * bbWidth * 2.0 - bbWidth, dx, dy, dz, 0);
    }

    @Unique
    public static void spawnFlameParticles(World world, double x, double y, double z, double bbHeight, double bbWidth) {
        double dx = random.nextGaussian() * 0.02;
        double dy = random.nextGaussian() * 0.02;
        double dz = random.nextGaussian() * 0.02;
        ParticleMaker.spawnParticle(world, "flame", x + (double)random.nextFloat() * bbWidth * 2.0 - bbWidth, y + (double)random.nextFloat() * bbHeight - bbHeight, z + (double)random.nextFloat() * bbWidth * 2.0 - bbWidth, dx, dy, dz, 0);
    }

    @Unique
    public static void spawnHeartParticles(World world, double x, double y, double z, double bbHeight, double bbWidth) {
        double dx = random.nextGaussian() * 0.02;
        double dy = random.nextGaussian() * 0.02;
        double dz = random.nextGaussian() * 0.02;
        for (int i = 0; i < 2; ++i) {
            ParticleMaker.spawnParticle(world, "heart", x + (double)random.nextFloat() * bbWidth * 2.0 - bbWidth, y + (double)random.nextFloat() * bbHeight - bbHeight, z + (double)random.nextFloat() * bbWidth * 2.0 - bbWidth, dx, dy, dz, 0);
        }
    }

    public static void spawnPoisonParticles(World world, double x, double y, double z, double bbHeight, double bbWidth) {
        double radius = bbWidth * 1.1;
        double centerY = y + bbHeight * 1.1;
        double theta = Math.PI * 2 * random.nextDouble();
        double posX = x + radius * Math.cos(theta);
        double posY = centerY + Math.min(random.nextDouble() * 0.03, 0.1);
        double posZ = z + radius * Math.sin(theta);
        double dy = random.nextDouble() * 0.05;
        ParticleMaker.spawnParticle(world, "poison", posX, posY, posZ, 0.0, dy, 0.0, 0);
    }

    public static void spawnRemedyParticle(@Nullable World world, double x, double y, double z, double bbHeight, double bbWidth) {
        double radius = bbWidth + 0.1;
        for (int i = 0; i < 36; ++i) {
            double theta = MathHelper.toRadians((float)(10 * i));
            double offX = radius * Math.cos(theta);
            double offZ = radius * Math.sin(theta);
            ParticleMaker.spawnParticle(world, "remedy", x, y + bbHeight * 1.2, z, offX * 0.13, 0.0, offZ * 0.13, 0);
        }
    }

    public static void spawnReplacementEffects(World world, int x, int y, int z) {
        for (int l = 0; l < 8; ++l) {
            double angle = Math.toRadians(l * 45);
            ParticleMaker.spawnParticle(world, "smoke", (double)x + 0.5, (double)y + 0.2, (double)z + 0.5, -Math.cos(angle) / 20.0, 0.03, -Math.sin(angle) / 20.0, 0);
            ParticleMaker.spawnParticle(world, "largesmoke", (double)x + Math.random(), (double)y + 0.2, (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
    }

    public static void spawnPoisonParticlesCluster(World world, double x, double y, double z, double bbHeight, double bbWidth) {
        double radiusOuter = Math.min(bbWidth * 1.2, bbHeight * 1.2);
        double centerY = bbHeight / 1.75;
        double theta = 1.5707963267948966 * random.nextDouble();
        double phi = Math.PI * 2 * random.nextDouble();
        double clusterX = x + radiusOuter * Math.sin(theta) * Math.cos(phi);
        double clusterY = y + radiusOuter * Math.cos(theta) + centerY;
        double clusterZ = z + radiusOuter * Math.sin(theta) * Math.sin(phi);
        double radius = 0.4;
        for (int i = 0; i < 3; ++i) {
            double thetaInner = Math.PI * 2 * random.nextDouble();
            double posX = clusterX + radius * Math.cos(thetaInner);
            double posY = clusterY + Math.min(random.nextDouble() * 0.03, 0.1);
            double posZ = clusterZ + radius * Math.sin(thetaInner);
            double dy = random.nextDouble() * 0.04;
            ParticleMaker.spawnParticle(world, "poison", posX, posY, posZ, 0.0, dy, 0.0, 0);
        }
    }

    public static void spawnFireSwordParticles(Mob target) {
        for (int particle = 0; particle < 16; ++particle) {
            Random random = new Random();
            double dx = target.x + random.nextDouble() * 0.5 - 0.25;
            double dy = target.y + 1.0 + random.nextDouble();
            double dz = target.z + random.nextDouble() * 0.5 - 0.25;
            double motionX = random.nextDouble() * 0.1 - 0.05;
            double motionY = random.nextDouble() * 0.1 - 0.05;
            double motionZ = random.nextDouble() * 0.1 - 0.05;
            ParticleMaker.spawnParticle(target.world, "flame", dx, dy, dz, motionX, motionY, motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "flame", dx, dy, dz, -motionX, motionY, motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "flame", dx, dy, dz, motionX, motionY, -motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "flame", dx, dy, dz, -motionX, motionY, -motionZ, 0);
        }
    }

    public static void spawnHolySwordParticles(Mob target) {
        for (int particle = 0; particle < 16; ++particle) {
            Random random = new Random();
            double dx = target.x + random.nextDouble() * 0.5 - 0.25;
            double dy = target.y + 1.0 + random.nextDouble();
            double dz = target.z + random.nextDouble() * 0.5 - 0.25;
            double motionX = random.nextDouble() * 0.1 - 0.05;
            double motionY = random.nextDouble() * 0.1 - 0.05;
            double motionZ = random.nextDouble() * 0.1 - 0.05;
            ParticleMaker.spawnParticle(target.world, "blueflame", dx, dy, dz, motionX, motionY, motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "blueflame", dx, dy, dz, -motionX, motionY, motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "blueflame", dx, dy, dz, motionX, motionY, -motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "blueflame", dx, dy, dz, -motionX, motionY, -motionZ, 0);
        }
    }

    public static void spawnLightningSwordParticles(Mob target) {
        Random random = new Random();
        double startY = target.y + 2.0;
        double endY = target.y;
        int numPoints = 16;
        double currentX = target.x;
        double currentZ = target.z;
        double stepY = (startY - endY) / (double)numPoints;
        for (int i = 0; i <= numPoints; ++i) {
            double y = startY - (double)i * stepY;
            if (i > 0) {
                double dx = (random.nextDouble() - 0.5) * 0.8;
                double dz = (random.nextDouble() - 0.5) * 0.8;
                currentX += dx;
                currentZ += dz;
            }
            double x = currentX;
            double z = currentZ;
            double motionX = random.nextDouble() * 0.1 - 0.05;
            double motionY = random.nextDouble() * 0.1 - 0.05;
            double motionZ = random.nextDouble() * 0.1 - 0.05;
            ParticleMaker.spawnParticle(target.world, "lightning", x, y, z, motionX, motionY, motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "lightning", x, y, z, -motionX, motionY, motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "lightning", x, y, z, motionX, motionY, -motionZ, 0);
            ParticleMaker.spawnParticle(target.world, "lightning", x, y, z, -motionX, motionY, -motionZ, 0);
        }
    }
}

