/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.items;

import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import teamport.aether.AetherMod;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.entity.vehicle.parachute.EntityParachute;
import teamport.aether.helper.ParticleMaker;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class ItemParachute
extends Item {
    Class<? extends EntityParachute> entity;

    public ItemParachute(String translationKey, String namespaceId, int id, Class<? extends EntityParachute> entity) {
        super(translationKey, namespaceId, id);
        this.entity = entity;
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player player) {
        if (player.fallDistance > 0.0f && !player.isInWater() && !EnvironmentHelper.isClientWorld()) {
            EntityParachute cloud;
            try {
                cloud = this.entity.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                AetherMod.LOGGER.error("Failed to spawn parachute cloud!");
                throw new RuntimeException(e);
            }
            cloud.absMoveTo(player.x, player.y - 2.0, player.z, player.yRot, player.xRot);
            world.entityJoinedWorld((Entity)cloud);
            ParticleMaker.spawnParticle(world, cloud.pathParticle, player.x + 0.5, player.y + 1.0, player.z + 0.5, 0.0, 0.0, 0.0, 0);
            player.startRiding((IVehicle)cloud);
            if (!EnvironmentHelper.isServerEnvironment()) {
                player.triggerAchievement((Stat)AetherAchievements.PARACHUTE);
            }
            if (player.gamemode.toolDurability()) {
                if (itemstack.getMaxDamage() == 1) {
                    itemstack.consumeItem(player);
                } else {
                    itemstack.damageItem(1, (Entity)player);
                }
            }
        }
        return itemstack;
    }
}

