/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.armor.player.gravitite;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.helper.ContainerHelper;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.items.AetherArmorMaterial;

@Mixin(value={Mob.class}, remap=false)
public abstract class MobMixinJump
extends Entity {
    @Shadow
    protected boolean isJumping;
    @Unique
    public boolean usedDoubleJump = false;
    @Unique
    public boolean isJumpingPrev = false;

    public MobMixinJump(@Nullable World world) {
        super(world);
    }

    @Inject(method={"jump"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/entity/Mob;isSprinting()Z")})
    public void aether$jump(CallbackInfo ci) {
        if (!((Mob)this instanceof Player)) {
            return;
        }
        Player player = (Player)this;
        if (ContainerHelper.countArmorPiecesOfMaterial(player.inventory, AetherArmorMaterial.GRAVITITE) >= 5) {
            this.yd = 1.05;
            this.fallDistance = 0.0f;
        }
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="FIELD", target="Lnet/minecraft/core/entity/Mob;moveStrafing:F", opcode=181, ordinal=1)})
    public void aether$onLivingUpdate(CallbackInfo ci) {
        if (!((Mob)this instanceof Player)) {
            return;
        }
        Player player = (Player)this;
        if (this.noPhysics) {
            this.usedDoubleJump = true;
            return;
        }
        if (ContainerHelper.countArmorPiecesOfMaterial(player.inventory, AetherArmorMaterial.GRAVITITE) < 5) {
            return;
        }
        if (!this.onGround && !this.isJumpingPrev && this.isJumping && !this.usedDoubleJump) {
            this.yd = 1.05;
            this.fallDistance = 0.0f;
            ParticleMaker.spawnCloudParticles(this.world, this.x, this.y, this.z, this.bbHeight);
            this.usedDoubleJump = true;
        }
        if (this.onGround) {
            this.usedDoubleJump = false;
        }
        this.isJumpingPrev = this.isJumping;
    }

    @WrapOperation(method={"causeFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/entity/Mob;hurt(Lnet/minecraft/core/entity/Entity;ILnet/minecraft/core/util/helper/DamageType;)Z")})
    public boolean negateFallDamage(Mob instance, Entity attacker, int damage, DamageType type, Operation<Boolean> original) {
        if (!(instance instanceof Player)) {
            return (Boolean)original.call(new Object[]{instance, attacker, damage, type});
        }
        Player player = (Player)instance;
        if (ContainerHelper.countArmorPiecesOfMaterial(player.inventory, AetherArmorMaterial.GRAVITITE) < 5) {
            return (Boolean)original.call(new Object[]{instance, attacker, damage, type});
        }
        player.inventory.damageArmor((damage -= 13) > 0 ? damage : 4);
        return false;
    }
}

