/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.armor.wolf;

import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.items.AetherArmorMaterial;

@Mixin(value={MobWolf.class}, remap=false)
public abstract class MobWolfMixinFireImmunity
extends MobAnimal {
    public MobWolfMixinFireImmunity(World world) {
        super(world);
    }

    @Inject(method={"lavaHurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void aether$lavaImmunity(CallbackInfo ci) {
        if (this.isImmuneToFire()) {
            if (this.world == null) {
                return;
            }
            ParticleMaker.spawnSmokeParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            ci.cancel();
        }
    }

    @Inject(method={"fireHurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void aether$fireImmunity(CallbackInfo ci) {
        if (this.isImmuneToFire()) {
            if (this.world == null) {
                return;
            }
            ParticleMaker.spawnSmokeParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            ci.cancel();
        }
    }

    public void thunderHit(EntityLightning bolt) {
        if (this.isImmuneToFire()) {
            if (this.world == null) {
                return;
            }
            ParticleMaker.spawnSmokeParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return;
        }
        super.thunderHit(bolt);
    }

    public void burn(int damage) {
        if (this.isImmuneToFire()) {
            if (this.world == null) {
                return;
            }
            ParticleMaker.spawnSmokeParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return;
        }
        super.burn(damage);
    }

    @Unique
    public boolean isImmuneToFire() {
        ArmorMaterial armorMaterial = ((MobWolf)this).getArmorMaterial();
        if (armorMaterial == null) {
            return false;
        }
        return armorMaterial.equals(AetherArmorMaterial.PHOENIX);
    }
}

