/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.block;

import net.minecraft.core.block.BlockLogicNote;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.AetherMod;
import teamport.aether.helper.ParticleMaker;

@Mixin(value={BlockLogicNote.class}, remap=false)
public abstract class BlockLogicNoteTriggerMixin {
    @Inject(method={"triggerEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void triggerEvent(World world, int x, int y, int z, int index, int data, CallbackInfo ci) {
        float f = (float)Math.pow(2.0, (double)(data - 12) / 12.0);
        String soundKey = BlockLogicNote.Instrument.getInstrumentFromIndex((int)index).soundKey;
        String soundEvent = index == AetherMod.FLUTE.index || index == AetherMod.CLICK.index || index == AetherMod.XYLOPHONE.index || index == AetherMod.BELL.index || index == AetherMod.TRUMPET.index || index == AetherMod.ORGAN.index || index == AetherMod.SITAR.index || index == AetherMod.TRANCE.index || index == AetherMod.SAXOPHONE.index || index == AetherMod.MUSICBOX.index ? "aether:note." + soundKey : "note." + soundKey;
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, soundEvent, 3.0f, f);
        ParticleMaker.spawnParticle(world, "note", (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, 0.0, 0.0, 0.0, data);
        ci.cancel();
    }
}

