/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.gui.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.ScaledResolution;
import net.minecraft.client.gui.toasts.GuiElementToastsHud;
import net.minecraft.client.render.Font;
import net.minecraft.core.Timer;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.DyeColor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.AetherClient;
import teamport.aether.AetherRemoteResourceDownloaderThread;

@Mixin(value={Minecraft.class}, remap=false)
public class ResourceDownloadToastMixin {
    @Shadow
    public GuiElementToastsHud guiToasts;
    @Shadow
    public Font font;
    @Shadow
    public ScaledResolution resolution;
    @Shadow
    private int ticksRan;
    @Shadow
    @Final
    private Timer timer;
    @Unique
    int dark;
    @Unique
    int light;
    @Unique
    int animLength;

    public ResourceDownloadToastMixin() {
        this.dark = DyeColor.SILVER.color.value;
        this.light = DyeColor.WHITE.color.value;
        this.animLength = 30;
    }

    @Inject(method={"run"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/toasts/GuiElementToastsHud;render(F)V", shift=At.Shift.AFTER)})
    public void renderResourceToast(CallbackInfo ci) {
        if (AetherClient.resourceDownloaderThread.state == AetherRemoteResourceDownloaderThread.State.DOWNLOADING) {
            int screenWidth = this.resolution.getScaledWidthScreenCoords();
            int screenHeight = this.resolution.getScaledHeightScreenCoords();
            int padding = 5;
            String message = String.format(I18n.getInstance().translateKey("aether.download_resources"), AetherClient.resourceDownloaderThread.progress.get(), AetherClient.resourceDownloaderThread.toDownload);
            float progress = (float)Math.sin((double)(((float)this.ticksRan + this.timer.partialTicks) % (float)this.animLength) / (double)this.animLength * Math.PI);
            this.guiToasts.drawString(this.font, message, screenWidth - this.font.getStringWidth(message) - padding, padding, ResourceDownloadToastMixin.mixColor(this.light, this.dark, progress));
        }
    }

    @Unique
    private static int mixColor(int colorA, int colorB, float ratio) {
        int alphaA = Color.alphaFromInt((int)colorA);
        int redA = Color.redFromInt((int)colorA);
        int blueA = Color.blueFromInt((int)colorA);
        int greenA = Color.greenFromInt((int)colorA);
        int alphaB = Color.alphaFromInt((int)colorB);
        int redB = Color.redFromInt((int)colorB);
        int blueB = Color.blueFromInt((int)colorB);
        int greenB = Color.greenFromInt((int)colorB);
        int alphaRes = (int)((float)alphaA * ratio + (float)alphaB * (1.0f - ratio));
        int redRes = (int)((float)redA * ratio + (float)redB * (1.0f - ratio));
        int blueRes = (int)((float)blueA * ratio + (float)blueB * (1.0f - ratio));
        int greenRes = (int)((float)greenA * ratio + (float)greenB * (1.0f - ratio));
        return Color.intToIntARGB((int)alphaRes, (int)redRes, (int)blueRes, (int)greenRes);
    }
}

