/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze.component;

import java.util.ArrayList;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import teamport.aether.AetherMod;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.boss.slider.MobBossSlider;
import teamport.aether.helper.Pair;
import teamport.aether.items.AetherItems;
import teamport.aether.world.feature.chest.WorldFeatureAetherBronzeChest;
import teamport.aether.world.feature.dungeon.bronze.DungeonLogicBronzeDungeon;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;
import teamport.aether.world.feature.util.map.DungeonMap;

public class BossRoom
extends BaseBronzeRoom {
    public static final BlockPallet ROOM_PALLET = new BlockPallet();
    DungeonLogicBronzeDungeon dungeon;
    private BaseBronzeRoom.Door bossDoor;

    public BossRoom() {
        this.length = 16;
        this.width = 16;
        this.height = 14;
        this.liquidTolerance = 0.0f;
        this.airTolerance = 0.0f;
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(6, 1, 0), Direction.UP, 4, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(15, 1, 6), Direction.UP, 4, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(6, 1, 15), Direction.UP, 4, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 6), Direction.UP, 4, Direction.SOUTH, 4);
    }

    public void makeShell() {
        this.room.add(WorldFeatureComponent.drawShell(this.random, ROOM_PALLET, Direction.SOUTH, this.width, Direction.UP, this.height, Direction.EAST, this.length, this.x, this.y, this.z, false));
        this.room.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, this.width - 2, Direction.UP, this.height - 2, Direction.SOUTH, this.length - 2, this.x + 1, this.y + 1, this.z + 1, false));
    }

    private void makeTreasureRoom() {
        this.decoration.add(WorldFeatureComponent.drawShell(this.random, ROOM_PALLET, Direction.EAST, 4, Direction.UP, 4, Direction.SOUTH, 4, this.x + 6, this.y - 2, this.z + 6, false));
        this.decoration.add(WorldFeatureComponent.drawVolume(0, 0, Direction.EAST, 2, Direction.UP, 2, Direction.SOUTH, 2, this.x + 7, this.y - 1, this.z + 7, false));
    }

    private void placeBoss() {
        this.dungeon = DungeonMap.register(DungeonLogicBronzeDungeon.class, this.world, this.world.getRandomSeed() + (long)this.random.nextInt(), this.x + 8, this.y + 2, this.z + 8);
        this.dungeon.hasGenerated = true;
        this.dungeon.setClearArea(new Pair<WorldFeaturePoint, WorldFeaturePoint>(WorldFeaturePoint.wfp(this.x, this.y - 2, this.z), WorldFeaturePoint.wfp(this.x + 16, this.y + 14, this.z + 16)));
        WorldFeatureAetherBronzeChest.bronzeChest().place(this.world, this.random, this.x + 7 + this.random.nextInt(2), this.y - 1, this.z + 7 + this.random.nextInt(2));
        ArrayList<WorldFeaturePoint> treasureDoor = new ArrayList<WorldFeaturePoint>();
        treasureDoor.add(WorldFeaturePoint.wfp(this.x + 7, this.y + 1, this.z + 7));
        treasureDoor.add(WorldFeaturePoint.wfp(this.x + 8, this.y + 1, this.z + 7));
        treasureDoor.add(WorldFeaturePoint.wfp(this.x + 7, this.y + 1, this.z + 8));
        treasureDoor.add(WorldFeaturePoint.wfp(this.x + 8, this.y + 1, this.z + 8));
        this.dungeon.setTreasureDoor(treasureDoor);
        MobBossSlider boss = new MobBossSlider(this.world);
        boss.moveTo(this.x + 8, this.y + 2, this.z + 8, 0.0f, 0.0f);
        boss.setReturnPoint(new WorldFeaturePoint(this.x + 8, this.y + 2, this.z + 8));
        boss.setTrophy(AetherItems.KEY_BRONZE.getDefaultStack());
        boss.setDungeonID(this.dungeon.id);
        this.world.entityJoinedWorld((Entity)boss);
    }

    @Override
    public void makeRoom() {
        this.makeShell();
        this.makeTreasureRoom();
    }

    @Override
    public void placeRoom() {
        this.room.place(this.world);
        this.decoration.place(this.world);
        this.placeBoss();
    }

    @Override
    public void markDoor(BaseBronzeRoom.Door door, BaseBronzeRoom.ClosingType closingType) {
        super.markDoor(door, closingType);
        if (closingType != BaseBronzeRoom.ClosingType.PLACED && door.mark != BaseBronzeRoom.ClosingType.PLACED) {
            return;
        }
        this.bossDoor = door;
        this.doors.forEach(d -> {
            d.mark = BaseBronzeRoom.ClosingType.ROOM_LOCKED;
        });
        if (door == null) {
            AetherMod.LOGGER.warn("Bronze dungeon door at: {}, {}, {} does not exist. Thus the slider door was not registered.", new Object[]{this.x, this.y, this.z});
            return;
        }
        int meta = BlockLogicRotatable.setDirection((int)0, (Direction)door.heading);
        WorldFeatureComponent doorBlock = WorldFeatureComponent.drawVolume(AetherBlocks.DOOR_DUNGEON_BRONZE.id(), meta, door.p1, door.p2, true);
        this.dungeon.setEntranceDoor(doorBlock.blockList);
    }

    public BaseBronzeRoom.Door getBossDoor() {
        return this.bossDoor;
    }

    static {
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_LOCKED.id(), 0, 90.0);
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_LIGHT_LOCKED.id(), 0, 10.0);
    }
}

