package teamport.aether.blocks.terrain;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import teamport.aether.entity.floatingBlock.EntityFloatingBlock;

public class BlockLogicBlockGravitite extends BlockLogic {
    public static boolean fallInstantly = false;

    public BlockLogicBlockGravitite(Block<?> block, Material material) {
        super(block, material);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!world.isClientSide) {
            int meta = world.getBlockMetadata(x, y, z);
            boolean wasPowered = (meta & 1) != 0;
            boolean isPowered = world.hasNeighborSignal(x, y, z);
            if (isPowered != wasPowered) {
                if (isPowered) {
                    world.setBlockMetadataWithNotify(x, y, z, 1);
                    tryToFall(world, x, y, z);
                } else {
                    world.setBlockMetadataWithNotify(x, y, z, 0);
                }
            }

        }
    }

    public void tryToFall(World world, int x, int y, int z) {
        boolean isPowered = world.hasNeighborSignal(x, y, z);
        if (isPowered) {
            if (canFallAbove(world, x, y + 1, z) && y < 256) {
                byte byte0 = 32;
                if (!fallInstantly && world.areBlocksLoaded(x - byte0, y - byte0, z - byte0, x + byte0, y + byte0, z + byte0)) {
                    EntityFloatingBlock entityFloatingBlock = new EntityFloatingBlock(world, (double) x + 0.5, (double) y + 0.5, (double) z + 0.5, this.block.id(), 0, null);
                    world.entityJoinedWorld(entityFloatingBlock);
                    world.setBlockWithNotify(x, y, z, 0);
                } else {
                    world.setBlockWithNotify(x, y, z, 0);

                    while (canFallAbove(world, x, y + 1, z) && y < 256) {
                        ++y;
                    }

                    if (y < 256) {
                        world.setBlockWithNotify(x, y, z, this.block.id());
                    }
                }
            }
        }
    }

    public int tickDelay() {
        return 3;
    }

    public static boolean canFallAbove(World world, int x, int y, int z) {
        Block<?> block = world.getBlock(x, y, z);
        return block == null || block.hasTag(BlockTags.PLACE_OVERWRITES);
    }


}
