package teamport.aether.entity.floatingBlock;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamport.aether.blocks.AetherBlocks;
import turniplabs.halplibe.helper.EnvironmentHelper;


// TODO fix multiplayer desync

///  all the comment were made to understand what the logic does

// Abandon all hope ye who enter here.

// BEWARE OF JANK
public class EntityFloatingBlock extends Entity {
    public CarriedBlock carriedBlock;
    public int floatTime;
    public boolean hasRemovedBlock = false;

    public EntityFloatingBlock(World world) {
        super(world);
        this.carriedBlock = new CarriedBlock(this, AetherBlocks.ORE_GRAVITITE_HOLYSTONE, 0, null);
        this.floatTime = 0;
        this.setSize(1.0F, 1.0F);
        this.heightOffset = this.bbHeight / 2.0F;
    }

    public EntityFloatingBlock(World world, double x, double y, double z, int blockId, int blockMeta, @Nullable TileEntity tileEntity) {
        super(world);
        this.carriedBlock = new CarriedBlock(this, blockId, blockMeta, tileEntity);
        if (tileEntity != null) {
            tileEntity.worldObj = null;
            tileEntity.carriedBlock = this.carriedBlock;
        }

        this.floatTime = 0;
        this.blocksBuilding = true;
        this.setSize(1.0F, 1.0F);
        this.heightOffset = this.bbHeight / 2.0F;
        this.setPos(x, y, z);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected boolean makeStepSound() {
        return false;
    }

    protected void defineSynchedData() {
    }

    public boolean isPickable() {
        return !this.removed;
    }

    public void tick() {
        // if air stop tick
        if (this.carriedBlock.blockId == 0) {
            this.remove();
            return;
        }

        // move the block do some calc
        this.pushesThisTick = 0;
        this.pushTime *= 0.98F;
        if (this.pushTime < 0.05F || (double) this.pushTime < 0.25 && this.onGround) {
            this.pushTime = 0.0F;
        }

        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if ((double) this.pushTime < 0.01 && this.yd <= 0.0) {
            ++this.floatTime;
        }

        // rising block
        this.yd += 0.04;

        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;

        int x = MathHelper.floor(this.x - 0.5);
        int y = MathHelper.floor(this.y);
        int z = MathHelper.floor(this.z - 0.5);

        if (this.world.getBlockId(x, y, z) == this.carriedBlock.blockId && !this.hasRemovedBlock) {
            this.world.setBlockWithNotify(x, y, z, 0);
            this.hasRemovedBlock = true;
        }

        boolean onCeiling = isOnCeiling(x, y, z);
        boolean atWorldHeight = this.y >= this.world.getHeightBlocks();

        boolean shouldStopExisting =
                onCeiling
                        || atWorldHeight
                        || this.isInWall()
                        || this.floatTime > 600;

        if (shouldStopExisting) {
            if (onCeiling) {
                this.y = MathHelper.floor(this.y) + 0.5;
                this.setPos(this.x, this.y, this.z);

                x = MathHelper.floor(this.x - 0.5);
                y = MathHelper.floor(this.y);
                z = MathHelper.floor(this.z - 0.5);
            }

            if (onCeiling || atWorldHeight) {
                this.xd *= 0.7;
                this.zd *= 0.7;
                this.yd *= -0.5;
            }

            if (!EnvironmentHelper.isClientWorld()) {
                if (
                        onCeiling && this.world.canBlockBePlacedAt(this.carriedBlock.blockId, x, y, z, true, Side.BOTTOM)
                ) {
                    boolean blockPlacedSuccessfully = this.world.setBlockAndMetadata(
                            x, y, z,
                            this.carriedBlock.blockId,
                            this.carriedBlock.metadata
                    );

                    if (blockPlacedSuccessfully) {
                        if (this.carriedBlock.entity != null) {
                            TileEntity oldEnt = this.world.getTileEntity(x, y, z);
                            if (oldEnt != null) oldEnt.invalidate();

                            this.carriedBlock.entity.validate();
                            this.carriedBlock.entity.x = x;
                            this.carriedBlock.entity.y = y;
                            this.carriedBlock.entity.z = z;
                            this.carriedBlock.entity.worldObj = this.world;
                            this.carriedBlock.entity.carriedBlock = null;

                            this.world.replaceBlockTileEntity(x, y, z, this.carriedBlock.entity);
                        }

                        this.world.notifyBlockChange(x, y, z, this.carriedBlock.blockId);

                        Entity rider = this.getPassenger();
                        if (rider != null) {
                            this.ejectRider();

                            if (this.carriedBlock.entity instanceof IVehicle) {
                                rider.startRiding((IVehicle) this.carriedBlock.entity);
                            }
                        }

                        this.remove();
                        return;
                    }

                    if (this.hasRemovedBlock) this.drop();
                }

                this.ejectRider();
                this.remove();
                return;
            }
        }

        this.carriedBlock.heldTick(this.world, this);
    }

    private boolean isOnCeiling(int x, int y, int z) {
        Block<?> blockAbove = this.world.getBlock(x, MathHelper.floor(y + 1), z);
        return blockAbove != null && blockAbove.id() != Blocks.COBWEB.id() &&
                !this.world.canBlockBePlacedAt(this.carriedBlock.blockId, x, MathHelper.floor(y + 1), z, true, Side.TOP) &&
                y + 1 < this.world.getHeightBlocks();
    }

    public void drop() {
        Block<?> block = this.carriedBlock.block();
        int i;
        if (block != null) {
            ItemStack[] drops = block.getBreakResult(this.world, EnumDropCause.SILK_TOUCH, this.carriedBlock.metadata, this.carriedBlock.entity);
            if (drops != null && drops.length > 0) {
                for (i = 0; i < drops.length; ++i) {
                    this.dropItem(drops[i], 0.0F);
                }
            }
        }

        if (this.carriedBlock.entity != null) {
            int x = MathHelper.round(this.x - 0.5);
            i = MathHelper.round(this.y);
            int z = MathHelper.round(this.z - 0.5);
            this.carriedBlock.entity.dropContents(this.world, x, i, z);
        }

    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putShort("Tile", (short) this.carriedBlock.blockId);
        tag.putShort("TileData", (short) this.carriedBlock.metadata);
        if (this.carriedBlock.entity != null) {
            CompoundTag entityTag = new CompoundTag();
            this.carriedBlock.entity.writeToNBT(entityTag);
            tag.putCompound("TileEntity", entityTag);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        this.carriedBlock = new CarriedBlock(this, tag.getShort("Tile") & 16383, tag.getShort("TileData") & 255,
                tag.containsKey("TileEntity") ? TileEntityDispatcher.createAndLoadEntity(tag.getCompound("TileEntity")) : null);
    }

    public void fling(double xd, double yd, double zd, float pushTime) {
        super.fling(xd, yd, zd, pushTime);
        this.floatTime = 0;
    }

    public float getShadowHeightOffs() {
        return 0.0F;
    }

    public boolean showBoundingBoxOnHover() {
        return true;
    }

    public double getRideHeight() {
        return 0.0;
    }
}