package teamport.aether.entity.projectile;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.items.AetherItems;

public class ProjectileKnifeLightning extends Projectile implements ProjectileAether, AetherProjectileDeathMessages<ProjectileKnifeLightning> {

    public ProjectileKnifeLightning(World world) {
        super(world);
    }

    public ProjectileKnifeLightning(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.modelItem = AetherItems.TOOL_KNIFE_LIGHTNING;
    }

    public ProjectileKnifeLightning(World world, Player owner) {
        super(world, owner);
    }

    public void initProjectile() {
        this.damage = 6;
        this.defaultGravity = 0.03F;
        this.defaultProjectileSpeed = 0.99F;
    }

    public void onHit(HitResult hitResult) {
        if (hitResult.entity != null) {
            hitResult.entity.hurt(this.owner, this.damage, DamageType.COMBAT);
            if (!world.isClientSide) {
                world.entityJoinedWorld(new EntityLightning(hitResult.entity.world, hitResult.entity.x, hitResult.entity.y, hitResult.entity.z));
            }

            doEffect();
            this.remove();
        }

        if (hitResult.hitType == HitResult.HitType.TILE) {
            if (!world.isClientSide) {
                world.entityJoinedWorld(
                        new EntityLightning(
                                world,
                                hitResult.x + hitResult.side.getOffsetX(),
                                hitResult.y + hitResult.side.getOffsetY(),
                                hitResult.z + hitResult.side.getOffsetZ()
                        )
                );
            }

            doEffect();
            this.remove();
        }
    }

    public void doEffect() {
        for (int j = 0; j < 8; ++j) {
            ParticleHelper.spawnParticle(world,
                    "item",
                    this.x, this.y, this.z,
                    world.rand.nextFloat(),
                    world.rand.nextFloat(),
                    world.rand.nextFloat(),
                    AetherItems.TOOL_KNIFE_LIGHTNING.id
            );
        }

        for (int j = 0; j < 16; j++) {
            ParticleHelper.spawnParticle(world,
                    "lightning",
                    this.x, this.y, this.z,
                    world.rand.nextFloat() * 0.25F * (world.rand.nextBoolean() ? -1 : 1),
                    world.rand.nextFloat() * 0.25F * -1,
                    world.rand.nextFloat() * 0.25F * (world.rand.nextBoolean() ? -1 : 1),
                    0
            );
        }
    }

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner, @Nullable CompoundTag compoundTag) {
        ProjectileKnifeLightning knife = new ProjectileKnifeLightning(world, x, y, z);
        if (hasVelocity) knife.setHeading(xd, yd, zd, 1, 0);
        if (owner instanceof Mob) knife.owner = (Mob) owner;
        return knife;
    }
}
