/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.moa;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

@Environment(value=EnvType.CLIENT)
public class ModelMoa
extends ModelBase {
    public Cube head;
    public Cube palate;
    public Cube body;
    public Cube legs;
    public Cube legs2;
    public Cube wings;
    public Cube wings2;
    public Cube jaw;
    public Cube neck;
    public Cube feather1;
    public Cube feather2;
    public Cube feather3;

    public ModelMoa() {
        int byte0 = 16;
        this.head = new Cube(0, 13);
        this.head.addBox(-2.0f, -4.0f, -6.0f, 4, 4, 8, 0.0f);
        this.head.setRotationPoint(0.0f, (float)(-8 + byte0), -4.0f);
        this.palate = new Cube(24, 13);
        this.palate.addBox(-2.0f, -1.0f, -6.0f, 4, 0, 8, -0.1f);
        this.palate.setRotationPoint(0.0f, (float)(-8 + byte0), -4.0f);
        this.jaw = new Cube(24, 13);
        this.jaw.addBox(-2.0f, -1.0f, -6.0f, 4, 1, 8, -0.1f);
        this.jaw.setRotationPoint(0.0f, (float)(-8 + byte0), -4.0f);
        this.body = new Cube(0, 0);
        this.body.addBox(-3.0f, -3.0f, 0.0f, 6, 8, 5, 0.0f);
        this.body.setRotationPoint(0.0f, (float)byte0, 0.0f);
        this.legs = new Cube(22, 0);
        this.legs.addBox(-1.0f, -1.0f, -1.0f, 2, 9, 2);
        this.legs.setRotationPoint(-2.0f, (float)byte0, 1.0f);
        this.legs2 = new Cube(22, 0);
        this.legs2.addBox(-1.0f, -1.0f, -1.0f, 2, 9, 2);
        this.legs2.setRotationPoint(2.0f, (float)byte0, 1.0f);
        this.wings = new Cube(52, 0);
        this.wings.addBox(-1.01f, -0.0f, -1.0f, 1, 8, 4);
        this.wings.setRotationPoint(-3.0f, (float)(-4 + byte0), 0.0f);
        this.wings2 = new Cube(52, 0);
        this.wings2.addBox(0.01f, -0.0f, -1.0f, 1, 8, 4);
        this.wings2.setRotationPoint(3.0f, (float)(-4 + byte0), 0.0f);
        this.neck = new Cube(44, 0);
        this.neck.addBox(-1.0f, -6.0f, -1.0f, 2, 6, 2);
        this.neck.setRotationPoint(0.0f, (float)(-2 + byte0), -4.0f);
        this.feather1 = new Cube(30, 0);
        this.feather1.addBox(-1.0f, -5.0f, 5.0f, 2, 1, 5, -0.3f);
        this.feather1.setRotationPoint(0.0f, (float)(1 + byte0), 1.0f);
        this.feather2 = new Cube(30, 0);
        this.feather2.addBox(-1.0f, -5.0f, 5.0f, 2, 1, 5, -0.3f);
        this.feather2.setRotationPoint(0.0f, (float)(1 + byte0), 1.0f);
        this.feather3 = new Cube(30, 0);
        this.feather3.addBox(-1.0f, -5.0f, 5.0f, 2, 1, 5, -0.3f);
        this.feather3.setRotationPoint(0.0f, (float)(1 + byte0), 1.0f);
        Cube var10000 = this.feather1;
        var10000.yRot += 0.5f;
        var10000 = this.feather2;
        var10000.yRot += 0.5f;
        var10000 = this.feather3;
        var10000.yRot += 0.5f;
    }

    public void render(float limbSwing, float limbyRot, float limbxRot, float headyRot, float headxRot, float scale) {
        this.setupAnimation(limbSwing, limbyRot, limbxRot, headyRot, headxRot, scale);
        this.head.render(scale);
        this.palate.render(scale);
        this.jaw.render(scale);
        this.body.render(scale);
        this.legs.render(scale);
        this.legs2.render(scale);
        this.wings.render(scale);
        this.wings2.render(scale);
        this.neck.render(scale);
        this.feather1.render(scale);
        this.feather2.render(scale);
        this.feather3.render(scale);
    }

    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        float f6 = (float)Math.PI;
        this.head.xRot = headPitch / 57.29578f;
        this.head.yRot = headYaw / 57.29578f;
        this.palate.xRot = this.head.xRot;
        this.palate.yRot = this.head.yRot;
        this.jaw.xRot = this.head.xRot;
        this.jaw.yRot = this.head.yRot;
        this.body.xRot = 1.5707964f;
        this.legs.xRot = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbYaw;
        this.legs2.xRot = MathHelper.cos((float)(limbSwing * 0.6662f + 3.141593f)) * 1.4f * limbYaw;
        if (limbPitch > 0.001f) {
            this.wings.z = -1.0f;
            this.wings2.z = -1.0f;
            this.wings.y = 12.0f;
            this.wings2.y = 12.0f;
            this.wings.xRot = 0.0f;
            this.wings2.xRot = 0.0f;
            this.wings.zRot = limbPitch;
            this.wings2.zRot = -limbPitch;
            this.legs.xRot = 0.6f;
            this.legs2.xRot = 0.6f;
        } else {
            this.wings.z = -3.0f;
            this.wings2.z = -3.0f;
            this.wings.y = 14.0f;
            this.wings2.y = 14.0f;
            this.wings.xRot = f6 / 2.0f;
            this.wings2.xRot = f6 / 2.0f;
            this.wings.zRot = 0.0f;
            this.wings2.zRot = 0.0f;
        }
        this.feather1.yRot = -0.375f;
        this.feather2.yRot = 0.0f;
        this.feather3.yRot = 0.375f;
        this.feather1.xRot = 0.25f;
        this.feather2.xRot = 0.25f;
        this.feather3.xRot = 0.25f;
        this.neck.xRot = 0.0f;
        this.neck.yRot = this.head.yRot;
        Cube var10000 = this.jaw;
        var10000.xRot += 0.35f;
    }
}

