/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.sheepuff;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import teamport.aether.entity.animal.sheepuff.MobSheepuff;

@Environment(value=EnvType.CLIENT)
public class EntityEntrySheepuff
extends EntityEntry<MobSheepuff> {
    public void onTick(MobSheepuff entity) {
    }

    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, MobSheepuff sheepuff) {
        ArrayList<ButtonElement> buttonList = new ArrayList<ButtonElement>();
        I18n translator = I18n.getInstance();
        ListenerSliderElement colorSlider = new ListenerSliderElement(-1, -120, 0, 120, 20, translator.translateKeyAndFormat("model.category.entity.sheepuff.slider.color", new Object[]{"White"}), 0.0f);
        colorSlider.setOnValueChanged(() -> {
            sheepuff.setFleeceColor(DyeColor.colorFromBlockMeta((int)((int)(colorSlider.sliderValue * 15.0))));
            String color = sheepuff.getFleeceColor().colorID;
            String c = String.valueOf(color.charAt(0));
            color = c.toUpperCase() + color.substring(1);
            colorSlider.displayString = translator.translateKeyAndFormat("model.category.entity.sheepuff.slider.color", new Object[]{color});
        });
        buttonList.add((ButtonElement)colorSlider);
        ListenerSliderElement woolStateSlider = new ListenerSliderElement(-1, -120, 21, 120, 20, translator.translateKeyAndFormat("model.category.entity.sheepuff.slider.wool_state", new Object[]{"Normal"}), 0.5f);
        woolStateSlider.setOnValueChanged(() -> {
            float sliderValue = (float)woolStateSlider.sliderValue;
            if (sliderValue < 0.33f) {
                sheepuff.setSheared(true);
                sheepuff.setPuffed(false);
                woolStateSlider.displayString = translator.translateKeyAndFormat("model.category.entity.sheepuff.slider.wool_state", new Object[]{"Sheared"});
            } else if (sliderValue < 0.66f) {
                sheepuff.setSheared(false);
                sheepuff.setPuffed(false);
                woolStateSlider.displayString = translator.translateKeyAndFormat("model.category.entity.sheepuff.slider.wool_state", new Object[]{"Normal"});
            } else {
                sheepuff.setSheared(false);
                sheepuff.setPuffed(true);
                woolStateSlider.displayString = translator.translateKeyAndFormat("model.category.entity.sheepuff.slider.wool_state", new Object[]{"Puffy"});
            }
        });
        buttonList.add((ButtonElement)woolStateSlider);
        return buttonList;
    }

    public MobSheepuff getEntityInstance(Minecraft mc, World world) {
        MobSheepuff sheepuff = new MobSheepuff(world);
        sheepuff.setFleeceColor(DyeColor.WHITE);
        sheepuff.setSheared(false);
        sheepuff.setPuffed(false);
        return sheepuff;
    }

    public void onOpen() {
    }

    public void onClose() {
    }
}

