/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.boss.slider;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import teamport.aether.entity.boss.slider.MobBossSlider;

@Environment(value=EnvType.CLIENT)
public class EntityEntryBossSlider
extends EntityEntry<MobBossSlider> {
    public void onTick(MobBossSlider entity) {
    }

    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, MobBossSlider slider) {
        ArrayList<ButtonElement> buttonList = new ArrayList<ButtonElement>();
        I18n translator = I18n.getInstance();
        ListenerSliderElement sliderStateSlider = new ListenerSliderElement(-1, -120, 0, 120, 20, translator.translateKeyAndFormat("model.category.entity.slider.slider.state", new Object[]{"Asleep Calm"}), 0.0f);
        sliderStateSlider.setOnValueChanged(() -> {
            float sliderValue = (float)sliderStateSlider.sliderValue;
            if (sliderValue < 0.25f) {
                slider.setState(MobBossSlider.State.ASLEEP);
                slider.setHealthRaw(slider.getMaxHealth());
                sliderStateSlider.displayString = translator.translateKeyAndFormat("model.category.entity.slider.slider.state", new Object[]{"Asleep Calm"});
            } else if (sliderValue < 0.5f) {
                slider.setState(MobBossSlider.State.ASLEEP);
                slider.setHealthRaw(1);
                sliderStateSlider.displayString = translator.translateKeyAndFormat("model.category.entity.slider.slider.state", new Object[]{"Asleep Angry"});
            } else if (sliderValue < 0.75f) {
                slider.setState(MobBossSlider.State.AWAKE);
                slider.setHealthRaw(slider.getMaxHealth());
                sliderStateSlider.displayString = translator.translateKeyAndFormat("model.category.entity.slider.slider.state", new Object[]{"Awake Calm"});
            } else {
                slider.setState(MobBossSlider.State.AWAKE);
                slider.setHealthRaw(1);
                sliderStateSlider.displayString = translator.translateKeyAndFormat("model.category.entity.slider.slider.state", new Object[]{"Awake Angry"});
            }
        });
        buttonList.add((ButtonElement)sliderStateSlider);
        return buttonList;
    }

    public MobBossSlider getEntityInstance(Minecraft mc, World world) {
        MobBossSlider slider = new MobBossSlider(world);
        slider.returnToOriginalState();
        return slider;
    }

    public void onOpen() {
    }

    public void onClose() {
    }
}

