/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.aechorplant;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemBucketEmpty;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.monster.MobMonsterAether;
import teamport.aether.entity.projectile.ProjectileNeedle;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.items.AetherItems;

public class MobAechorPlant
extends MobMonsterAether
implements Enemy,
AetherDeathMessage {
    public Mob target;
    public int attackCooldown;
    public int smokeTime;
    public boolean hasTarget;
    public float sinage;

    public MobAechorPlant(World world1) {
        super(world1);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"aechorplant");
        this.sinage = this.random.nextFloat() * 6.0f;
        this.attackCooldown = 0;
        this.smokeTime = 0;
        this.hasTarget = false;
        this.setSize(1.0f, 1.0f);
        this.setPos(this.x, this.y, this.z);
        this.scoreValue = 200;
        this.mobDrops.add(new WeightedRandomLootObject(AetherItems.PETAL_AECHOR.getDefaultStack(), 1, 4));
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 1;
    }

    public int getMaxHealth() {
        return 14;
    }

    @Override
    public boolean canSpawnHere() {
        int z;
        int y;
        int x = MathHelper.floor((double)this.x);
        if (this.world.getBlockId(x, (y = MathHelper.floor((double)this.bb.minY)) - 1, z = MathHelper.floor((double)this.z)) != AetherBlocks.GRASS_AETHER.id()) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Block, x, y, z) > 7) {
            return false;
        }
        int[] adjacentOffsets = new int[]{-1, 0, 1, 0, 0, -1, 0, 1, -1, -1, -1, 1, 1, -1, 1, 1};
        for (int i = 0; i < 8; ++i) {
            int offsetX = adjacentOffsets[i * 2];
            int offsetZ = adjacentOffsets[i * 2 + 1];
            int blockId = this.world.getBlockId(x + offsetX, y, z + offsetZ);
            Block block = Blocks.blocksList[blockId];
            if (block == null || !block.isCubeShaped()) continue;
            return false;
        }
        return true;
    }

    protected boolean isMovementBlocked() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public void onLivingUpdate() {
        if (this.getHealth() > 0 && this.onGround) {
            ++this.entityAge;
            this.tryToDespawn();
        } else {
            super.onLivingUpdate();
        }
        this.sinage = this.hurtTime > 0 ? (this.sinage += 0.9f) : (this.hasTarget ? (this.sinage += 0.3f) : (this.sinage += 0.1f));
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
        }
        if (this.target == null) {
            this.target = (Player)this.findPlayerToAttack();
        }
        if (this.target != null) {
            if (!this.canEntityBeSeen((Entity)this.target)) {
                this.attackCooldown = 0;
            }
            if (!this.target.isAlive() || (double)this.target.distanceTo((Entity)this) > 12.0) {
                this.target = null;
                this.attackCooldown = 0;
            } else if (this.attackCooldown >= 20 && this.canEntityBeSeen((Entity)this.target) && (double)this.target.distanceTo((Entity)this) < 6.5 && this.getHealth() >= 0) {
                this.shootTarget((Entity)this.target);
                this.attackCooldown = -20;
            }
            if (this.attackCooldown < 20) {
                ++this.attackCooldown;
            }
        }
        ++this.smokeTime;
        if (this.smokeTime >= (this.hasTarget ? 3 : 8)) {
            int k;
            int j;
            this.smokeTime = 0;
            int i = MathHelper.floor((double)this.x);
            if (this.world.getBlockId(i, (j = MathHelper.floor((double)this.bb.minY)) - 1, k = MathHelper.floor((double)this.z)) != AetherBlocks.GRASS_AETHER.id() && this.onGround) {
                this.hurt(null, 999999, DamageType.FALL);
            }
        }
        this.hasTarget = this.target != null;
    }

    public boolean canEntityBeSeen(Entity entity) {
        return this.world.checkBlockCollisionBetweenPoints(Vec3.getTempVec3((double)this.x, (double)(this.y + (double)this.getHeadHeight()), (double)this.z), Vec3.getTempVec3((double)entity.x, (double)(entity.y + (double)entity.getHeadHeight()), (double)entity.z), false, true, false) == null;
    }

    public void shootTarget(Entity target) {
        if (this.world.getDifficulty().canHostileMobsSpawn() && !this.world.isClientSide) {
            double d1 = this.target.x - this.x;
            double d2 = this.target.z - this.z;
            double sqrt = Math.sqrt(d1 * d1 + d2 * d2 + 0.1);
            double d3 = 1.5 / sqrt;
            d1 *= d3;
            d2 *= d3;
            double dX = target.x - this.x;
            double dZ = target.z - this.z;
            ProjectileNeedle needle = new ProjectileNeedle(this.world, (Mob)this);
            needle.y = this.y + 0.5;
            double h = target.y + (double)target.getHeadHeight() - 0.8 - needle.y;
            float f1 = MathHelper.sqrt((double)(d1 * d1 + d2 * d2)) * 0.2f;
            needle.setHeading(dX, h + (double)f1, dZ, 0.6f, 12.0f);
            this.world.playSoundAtEntity(null, (Entity)this, "random.bow", 0.3f, 2.0f / (this.random.nextFloat() * 0.4f + 0.8f));
            this.world.entityJoinedWorld((Entity)needle);
        }
    }

    public String getHurtSound() {
        return "damage.hurtflesh";
    }

    public String getDeathSound() {
        return "damage.fallbig";
    }

    public void knockBack(Entity entity, int damage, double xd, double yd) {
        for (int i = 0; i < 8; ++i) {
            double d1 = this.x + (double)(this.random.nextFloat() - this.random.nextFloat()) * 0.5;
            double d2 = this.y + 0.25 + (double)(this.random.nextFloat() - this.random.nextFloat()) * 0.5;
            double d3 = this.z + (double)(this.random.nextFloat() - this.random.nextFloat()) * 0.5;
            double d4 = (double)(this.random.nextFloat() - this.random.nextFloat()) * 0.5;
            double d5 = (double)(this.random.nextFloat() - this.random.nextFloat()) * 0.5;
            ParticleHelper.spawnParticle(this.world, "portal", d1, d2, d3, d4, 0.25, d5, 0);
        }
        if (this.getHealth() <= 0) {
            super.knockBack(entity, damage, xd, yd);
        }
    }

    public boolean interact(@NotNull Player player) {
        ItemStack itemstack = player.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == AetherItems.BUCKET_SKYROOT.id) {
            ItemBucketEmpty.useBucket((Player)player, (ItemStack)new ItemStack(AetherItems.BUCKET_SKYROOT_POISON));
            return true;
        }
        return super.interact(player);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("AttTime", (short)this.attackCooldown);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.attackCooldown = tag.getShort("AttTime");
        this.setPos(this.x, this.y, this.z);
    }
}

