/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.entity.projectile.AetherProjectileDeathMessages;
import teamport.aether.entity.projectile.ProjectileAether;
import teamport.aether.helper.ParticleHelper;

public class ProjectileHammerHead
extends Projectile
implements ProjectileAether,
AetherProjectileDeathMessages<ProjectileHammerHead> {
    public ProjectileHammerHead(World world) {
        super(world);
        this.initProjectile();
    }

    public ProjectileHammerHead(World world, Mob owner) {
        super(world, owner);
        this.initProjectile();
    }

    public void initProjectile() {
        this.damage = 10;
        this.defaultGravity = 0.0f;
        this.defaultProjectileSpeed = 0.99f;
        this.setSize(1.0f, 1.0f);
    }

    public ProjectileHammerHead(World world, double x, double y, double z) {
        super(world);
        this.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        ++this.ticksInAir;
        if (this.ticksInAir > 200) {
            this.doEffect();
            this.remove();
        }
    }

    public void onHit(HitResult hitResult) {
        if (hitResult.entity != null) {
            hitResult.entity.hurt((Entity)this.owner, this.damage, DamageType.COMBAT);
            this.doEffect();
            this.remove();
        }
        if (hitResult.hitType == HitResult.HitType.TILE) {
            this.doEffect();
            this.remove();
        }
    }

    public void doEffect() {
        this.world.playSoundAtEntity(null, (Entity)this, "random.explode", 0.5f, 0.5f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
        for (int j = 0; j < 8; ++j) {
            ParticleHelper.spawnParticle(this.world, "explode", this.x, this.y, this.z, 0.0, 0.0, 0.0, 0);
            ParticleHelper.spawnParticle(this.world, "smoke", this.x, this.y, this.z, 0.0, 0.0, 0.0, 0);
            ParticleHelper.spawnParticle(this.world, "largesmoke", this.x, this.y, this.z, 0.0, 0.0, 0.0, 0);
            ParticleHelper.spawnParticle(this.world, "flame", this.x, this.y, this.z, 0.0, 0.0, 0.0, 0);
        }
    }

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner, @Nullable CompoundTag compoundTag) {
        ProjectileHammerHead hammer = new ProjectileHammerHead(world, x, y, z);
        if (hasVelocity) {
            hammer.setHeading(xd, yd, zd, 1.0f, 0.0f);
        }
        if (owner instanceof Mob) {
            hammer.owner = (Mob)owner;
        }
        return hammer;
    }
}

