/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.tile;

import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.AetherRecipes;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.blocks.machine.BlockLogicIncubator;
import teamport.aether.entity.animal.moa.MobMoaBlack;
import teamport.aether.entity.animal.moa.MobMoaBlue;
import teamport.aether.entity.animal.moa.MobMoaWhite;
import teamport.aether.entity.tile.AetherTileEntityMachine;
import teamport.aether.lookup.LookupFuelIncubator;
import teamport.aether.recipe.RecipeEntity;
import teamport.aether.recipe.RecipeEntryIncubator;

public class TileEntityIncubator
extends AetherTileEntityMachine {
    Player thePlayer;

    public TileEntityIncubator() {
        this.containerItemStacks = new ItemStack[2];
    }

    @Override
    public String getNameTranslationKey() {
        return "aether.container.incubator.name";
    }

    @Override
    public void tick() {
        boolean isEnergyTimeHigherThan0 = this.currentEnergyTime > 0;
        boolean updateMachine = false;
        if (this.currentEnergyTime > 0) {
            --this.currentEnergyTime;
        }
        if (this.canProcess()) {
            this.maxProcessTime = (Integer)AetherRecipes.INCUBATOR.findRecipe(this.containerItemStacks[0]).getData();
        }
        if (this.isUpdateMachine(updateMachine, isEnergyTimeHigherThan0)) {
            this.setChanged();
        }
    }

    public boolean isUpdateMachine(boolean updateMachine, boolean isEnergyTimeHigherThan0) {
        if (this.worldObj == null || !this.worldObj.isClientSide) {
            updateMachine = this.eternallyLit(updateMachine);
            if (this.currentEnergyTime == 0 && this.containerItemStacks[1] != null && this.canProcess()) {
                this.maxEnergyTime = this.currentEnergyTime = this.getEnergyTimeFromItem(this.containerItemStacks[1]);
                if (this.currentEnergyTime > 0) {
                    updateMachine = true;
                    if (this.containerItemStacks[1] != null) {
                        --this.containerItemStacks[1].stackSize;
                        if (this.containerItemStacks[1].stackSize <= 0) {
                            this.containerItemStacks[1] = null;
                        }
                    }
                }
            }
            if (this.isProcessing() && this.canProcess()) {
                ++this.currentProcessTime;
                if (this.currentProcessTime >= this.maxProcessTime) {
                    this.currentProcessTime = 0;
                    this.processItem();
                    updateMachine = true;
                }
            } else {
                this.currentProcessTime = 0;
            }
            if (isEnergyTimeHigherThan0 != this.currentEnergyTime > 0) {
                this.updateContainer(false);
                updateMachine = true;
            }
            if (this.containerItemStacks[0] == null) {
                updateMachine = true;
            }
        }
        return updateMachine;
    }

    public boolean eternallyLit(boolean updateMachine) {
        if ((this.worldObj == null || this.worldObj.getBlockId(this.x, this.y, this.z) == AetherBlocks.INCUBATOR_IDLE.id()) && this.currentEnergyTime == 0 && this.containerItemStacks[0] == null && this.containerItemStacks[1] != null && this.containerItemStacks[1].itemID == Blocks.WOOL.id()) {
            --this.containerItemStacks[1].stackSize;
            if (this.containerItemStacks[1].stackSize <= 0) {
                this.containerItemStacks[1] = null;
            }
            this.updateContainer(true);
            return true;
        }
        return updateMachine;
    }

    @Override
    @Nullable
    public ItemStack removeItem(int index, int takeAmount) {
        if (this.containerItemStacks[index] != null) {
            if (this.containerItemStacks[index].stackSize <= takeAmount) {
                ItemStack itemstack = this.containerItemStacks[index];
                this.containerItemStacks[index] = null;
                if (this.worldObj != null && index == 0) {
                    this.worldObj.markBlockNeedsUpdate(this.x, this.y, this.z);
                }
                return itemstack;
            }
            ItemStack itemstack1 = this.containerItemStacks[index].splitStack(takeAmount);
            if (this.containerItemStacks[index].stackSize <= 0) {
                this.containerItemStacks[index] = null;
                if (this.worldObj != null && index == 0) {
                    this.worldObj.markBlockNeedsUpdate(this.x, this.y, this.z);
                }
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setItem(int index, @Nullable ItemStack itemstack) {
        this.containerItemStacks[index] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getMaxStackSize()) {
            itemstack.stackSize = this.getMaxStackSize();
        }
        if (this.worldObj != null && index == 0) {
            this.worldObj.markBlockNeedsUpdate(this.x, this.y, this.z);
        }
    }

    @Override
    public void processItem() {
        Player player;
        if (!this.canProcess()) {
            return;
        }
        RecipeEntryIncubator recipe = AetherRecipes.INCUBATOR.findRecipe(this.containerItemStacks[0]);
        Class entityClazz = EntityDispatcher.classForId((String)((RecipeEntity)recipe.getOutput()).getEntity());
        if (entityClazz == null) {
            return;
        }
        Entity entity = this.createEntity(entityClazz);
        if (entity == null) {
            return;
        }
        entity.moveTo((double)this.x + 0.5, (double)(this.y + 1), (double)this.z, 0.0f, 0.0f);
        this.worldObj.entityJoinedWorld(entity);
        --this.containerItemStacks[0].stackSize;
        if (this.containerItemStacks[0].stackSize <= 0) {
            this.containerItemStacks[0] = null;
        }
        if ((entity instanceof MobMoaBlue || entity instanceof MobMoaWhite || entity instanceof MobMoaBlack) && (player = this.worldObj.getClosestPlayerToEntity(entity, 16.0)) != null) {
            player.triggerAchievement((Stat)AetherAchievements.MOA);
        }
    }

    private Entity createEntity(Class<? extends Entity> entityClazz) {
        Entity entity = EntityDispatcher.createEntityInWorld(entityClazz, (World)this.worldObj);
        if (entity instanceof MobMoaBlue) {
            ((MobMoaBlue)entity).setTamed(true);
        }
        if (entity instanceof MobSlime) {
            ((MobSlime)entity).setSlimeSize(this.random.nextInt(4) + 1);
        }
        return entity;
    }

    @Override
    public boolean canProcess() {
        if (this.containerItemStacks[0] == null) {
            return false;
        }
        return AetherRecipes.INCUBATOR.findOutput(this.containerItemStacks[0]) != null;
    }

    @Override
    public Packet getDescriptionPacket() {
        return this.containerItemStacks[0] != null ? new PacketTileEntityData((TileEntity)this) : null;
    }

    @Override
    public void updateContainer(boolean forceLit) {
        if (this.worldObj != null) {
            BlockLogicIncubator.updateFurnaceBlockState(forceLit | this.currentEnergyTime > 0, this.worldObj, this.x, this.y, this.z);
            return;
        }
        if (this.carriedBlock != null) {
            this.carriedBlock.blockId = forceLit | this.currentEnergyTime > 0 ? AetherBlocks.INCUBATOR_ACTIVE.id() : AetherBlocks.INCUBATOR_IDLE.id();
        }
    }

    @Override
    public int getEnergyTimeFromItem(ItemStack itemStack) {
        return itemStack == null ? 0 : LookupFuelIncubator.instance.getFuelYield(itemStack.getItem().id);
    }

    @Override
    public void dropContents(World world, int x, int y, int z) {
        super.dropContents(world, x, y, z);
        if (!BlockLogicIncubator.keepIncubatorInventory) {
            for (int l = 0; l < this.getContainerSize(); ++l) {
                ItemStack itemstack = this.getItem(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityItem.xd = (float)this.random.nextGaussian() * f3;
                    entityItem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityItem.zd = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld((Entity)entityItem);
                }
            }
        }
    }
}

