/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.world.World;

@Environment(value=EnvType.CLIENT)
public class ParticleGoldenDust
extends Particle {
    public ParticleGoldenDust(World world, double x, double y, double z, double xa, double ya, double za) {
        super(world, x, y, z, xa, ya, za);
        this.bCol = 0.1f;
        this.gCol = 0.8f;
        this.rCol = 1.0f;
        this.gravity = 0.041666668f;
        this.size /= 2.0f;
        this.lifetime *= 8;
        this.yd = 0.0;
        this.xd = 0.0;
        this.zd = 0.0;
    }

    public boolean collidesWithBlock(Block<?> block, int metadata) {
        return !Block.hasLogicClass(block, BlockLogicLeavesBase.class);
    }

    public void tick() {
        int val;
        float windDirection = this.world.worldType.getWindManager().getWindDirection(this.world, (float)this.x, (float)this.y, (float)this.z);
        float windIntensity = this.world.worldType.getWindManager().getWindIntensity(this.world, (float)this.x, (float)this.y, (float)this.z) * 0.01f;
        float dx = (float)(Math.cos((double)windDirection * Math.PI * 2.0) * ((double)windIntensity / 4.0));
        float dz = (float)(Math.sin((double)windDirection * Math.PI * 2.0) * ((double)windIntensity / 4.0));
        this.xd += (double)(dx / 2.0f);
        this.zd += (double)(dz / 2.0f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.tex = (val = 7 - this.age * 8 / this.lifetime) >= 0 ? TextureRegistry.getTexture((String)("minecraft:particle/puff_" + val)) : null;
        this.yd -= 0.04 * (double)this.gravity;
        if (this.onGround) {
            this.xd *= 0.0;
            this.zd *= 0.0;
        }
        this.move(this.xd, this.yd, this.zd);
    }
}

