/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

@Environment(value=EnvType.CLIENT)
public class ParticleSnowflake
extends Particle {
    public ParticleSnowflake(World world, double x, double y, double z, double xa, double ya, double za) {
        super(world, x, y, z, xa, ya, za);
        this.tex = TextureRegistry.getTexture((String)"aether:particle/snowflake");
        this.setScale(this.random.nextFloat() * 0.2f + 0.8f);
        float speed = (float)(Math.random() * (double)0.05f + (double)0.05f);
        float dd = MathHelper.sqrt((double)(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd));
        if (dd > 0.0f) {
            this.xd = this.xd / (double)dd * (double)speed;
            this.zd = this.zd / (double)dd * (double)speed;
        }
        this.yd = -0.02f - this.random.nextFloat() * 0.01f;
        this.gravity = 0.01f;
        this.lifetime = (int)(20.0f / (this.random.nextFloat() * 0.5f + 0.5f));
        this.xd *= (double)0.8f;
        this.zd *= (double)0.8f;
    }

    public void tick() {
        super.tick();
        this.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.002f);
        this.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.002f);
        this.xd *= (double)0.99f;
        this.zd *= (double)0.99f;
        if (this.onGround) {
            this.lifetime = Math.min(this.lifetime, this.age + 5);
        }
    }
}

