/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScreenHudDesigner;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.core.block.Block;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.phys.HitResult;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoManager;
import toufoumaster.btwaila.gui.components.WailaTextComponent;
import toufoumaster.btwaila.mixin.mixins.accessors.IPlayerControllerAccessor;

public class HarvestInfoComponent
extends WailaTextComponent {
    public HarvestInfoComponent(String key, Layout layout) {
        super(key, 8, layout);
    }

    public int getAnchorY(ComponentAnchor anchor) {
        return (int)(anchor.yPosition * (float)this.getYSize(Minecraft.getMinecraft()));
    }

    public int getYSize(Minecraft mc) {
        if (!(mc.currentScreen instanceof ScreenHudDesigner) && !this.isVisible(mc)) {
            return 0;
        }
        return this.height();
    }

    public boolean isVisible(Minecraft minecraft) {
        return (Boolean)this.modSettings().bTWaila$getShowHarvestText().value != false && minecraft.gameSettings.immersiveMode.drawHotbar() && minecraft.objectMouseOver != null && minecraft.objectMouseOver.hitType == HitResult.HitType.TILE && minecraft.thePlayer != null && minecraft.thePlayer.gamemode == Gamemode.survival;
    }

    @Override
    public void renderPost(Minecraft minecraft, HudIngame HudIngame2, int xScreenSize, int yScreenSize, float f) {
        PlayerLocal player = minecraft.thePlayer;
        HitResult hitResult = minecraft.objectMouseOver;
        if (hitResult == null || player == null) {
            this.renderHarvestInfo(0xFF7F7F, "You shouldn't ever see this message.");
            return;
        }
        Block block = minecraft.currentWorld.getBlock(hitResult.x, hitResult.y, hitResult.z);
        if (player.getGamemode() == Gamemode.survival) {
            float damage;
            int miningLevelColor = 0xAFFFAF;
            String harvestString = BTWaila.translator.translateKey("btwaila.component.harvest.info.harvestable");
            if (!player.canHarvestBlock(block)) {
                harvestString = BTWaila.translator.translateKey("btwaila.component.harvest.info.notharvestable");
                miningLevelColor = 0xFFAFAF;
            }
            if ((damage = ((IPlayerControllerAccessor)minecraft.playerController).getCurrentDamage()) != 0.0f) {
                harvestString = BTWaila.translator.translateKey("btwaila.component.harvest.info.harvesting").replace("{progress}", String.valueOf((int)(damage * 100.0f)));
            }
            this.renderHarvestInfo(miningLevelColor, harvestString);
        }
    }

    @Override
    public void renderPreviewPost(Minecraft minecraft, Gui gui, Layout layout, int xScreenSize, int yScreenSize) {
        if (((Boolean)this.modSettings().bTWaila$getShowHarvestText().value).booleanValue() && DemoManager.getCurrentEntry().block != null) {
            this.renderHarvestInfo(0xFF7F7F, BTWaila.translator.translateKey("btwaila.component.harvest.info.notharvestable"));
        }
    }

    protected void renderHarvestInfo(int miningLevelColor, String harvestString) {
        this.drawStringJustified(harvestString, 0, this.getXSize(this.minecraft), miningLevelColor);
    }
}

