/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class LongAttribute
extends NumberAttribute<Long> {
    public LongAttribute(String key, Long defaultValue, Long minValue, Long maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public LongAttribute(String key, Long defaultValue) {
        super(key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public Long calculate(IHasEffects target) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                long value = (Long)this.getBaseValue();
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (((Number)modifier.calculate(effectStack)).longValue() <= value) break;
                            value = ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100L * ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100L * ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).longValue();
                        }
                    }
                }
                return Math.min((Long)this.maxValue, Math.max(value, (Long)this.minValue));
            }
            return (Long)this.getBaseValue();
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }

    @Override
    public Long calculate(IHasEffects target, Long baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this)) continue;
                long value = baseValue;
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (((Number)modifier.calculate(effectStack)).longValue() <= value) break;
                            value = ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100L * ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100L * ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).longValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).longValue();
                        }
                    }
                }
                return Math.min((Long)this.maxValue, Math.max(value, (Long)this.minValue));
            }
            return baseValue;
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

