/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeInteger;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Iterator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.Effects;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.command.argument.ArgumentTypeEffect;

public class CommandEffects
implements CommandManager.CommandRegistry {
    public static SimpleCommandExceptionType INCOMPATIBLE_ENTITY;

    public void register(CommandDispatcher<CommandSource> commandDispatcher) {
        INCOMPATIBLE_ENTITY = new SimpleCommandExceptionType((Message)new LiteralMessage(I18n.getInstance().translateKey("error.catalyst-effects.incompatibleEntity")));
        commandDispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"effect").then(ArgumentBuilderLiteral.literal((String)"list").executes(ctx -> {
            ((CommandSource)ctx.getSource()).sendMessage("Available effects:");
            Iterator iterator = Effects.getInstance().iterator();
            while (iterator.hasNext()) {
                Effect effect = (Effect)iterator.next();
                ((CommandSource)ctx.getSource()).sendMessage("- " + Effects.getInstance().getKey(effect));
            }
            return 1;
        }))).then(((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"remove").requires(src -> src.hasAdmin() && src.getSender() != null)).then(ArgumentBuilderLiteral.literal((String)"all").executes(ctx -> {
            if (!(((CommandSource)ctx.getSource()).getSender() instanceof IHasEffects)) {
                throw INCOMPATIBLE_ENTITY.create();
            }
            IHasEffects effects = (IHasEffects)((CommandSource)ctx.getSource()).getSender();
            effects.getContainer().removeAll();
            ((CommandSource)ctx.getSource()).sendMessage("Removed all effects.");
            return 1;
        }))).then(ArgumentBuilderRequired.argument((String)"name", ArgumentTypeEffect.effect()).executes(ctx -> {
            Effect effect = ArgumentTypeEffect.getEffect(ctx, "name");
            if (!(((CommandSource)ctx.getSource()).getSender() instanceof IHasEffects)) {
                throw INCOMPATIBLE_ENTITY.create();
            }
            IHasEffects effects = (IHasEffects)((CommandSource)ctx.getSource()).getSender();
            effects.getContainer().remove(effect);
            return 1;
        })))).then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"add").requires(src -> src.hasAdmin() && src.getSender() != null)).then(ArgumentBuilderRequired.argument((String)"name", ArgumentTypeEffect.effect()).then(ArgumentBuilderRequired.argument((String)"duration", (ArgumentType)ArgumentTypeInteger.integer()).then(ArgumentBuilderRequired.argument((String)"amount", (ArgumentType)ArgumentTypeInteger.integer()).executes(ctx -> {
            Effect effect = ArgumentTypeEffect.getEffect(ctx, "name");
            int duration = ArgumentTypeInteger.getInteger((CommandContext)ctx, (String)"duration");
            int amount = ArgumentTypeInteger.getInteger((CommandContext)ctx, (String)"amount");
            if (!(((CommandSource)ctx.getSource()).getSender() instanceof IHasEffects)) {
                throw INCOMPATIBLE_ENTITY.create();
            }
            IHasEffects effects = (IHasEffects)((CommandSource)ctx.getSource()).getSender();
            EffectStack stack = new EffectStack(effects, effect, duration, amount);
            effects.getContainer().add(stack);
            stack.start(effects.getContainer());
            return 1;
        }))))));
    }
}

