/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc;

import fiveavian.proxvc.api.ClientEvents;
import fiveavian.proxvc.gui.HudComponentStatus;
import fiveavian.proxvc.gui.HudComponentWaveForm;
import fiveavian.proxvc.gui.MicrophoneListComponent;
import fiveavian.proxvc.gui.VolumeMixerComponent;
import fiveavian.proxvc.util.EnvironmentDescriptor;
import fiveavian.proxvc.util.MixerStore;
import fiveavian.proxvc.util.OptionStore;
import fiveavian.proxvc.util.Waveforms;
import fiveavian.proxvc.vc.AttenuationProfile;
import fiveavian.proxvc.vc.AudioInputDevice;
import fiveavian.proxvc.vc.StreamingAudioSource;
import fiveavian.proxvc.vc.client.VCInputClient;
import fiveavian.proxvc.vc.client.VCOutputClient;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.components.BooleanOptionComponent;
import net.minecraft.client.gui.options.components.FloatOptionComponent;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.OptionBoolean;
import net.minecraft.client.option.OptionEnum;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.option.OptionString;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.packet.PacketLogin;
import net.minecraft.core.util.phys.Vec3;
import org.lwjgl.input.Keyboard;
import org.lwjgl.openal.AL10;

public class ProxVCClient
implements ClientModInitializer {
    public static ProxVCClient instance;
    public Minecraft client;
    public DatagramSocket socket;
    public AudioInputDevice device;
    public final Map<Integer, StreamingAudioSource> sources = new HashMap<Integer, StreamingAudioSource>();
    public SocketAddress serverAddress;
    private Thread inputThread;
    private Thread outputThread;
    public Texture statusIconTexture;
    public final KeyBinding keyMute = new KeyBinding("key.mute").setDefault(InputDevice.keyboard, Keyboard.KEY_M);
    private boolean isMutePressed = false;
    public final KeyBinding keyPushToTalk = new KeyBinding("key.push_to_talk").setDefault(InputDevice.keyboard, Keyboard.KEY_V);
    public final KeyBinding keyOpenMenu = new KeyBinding("key.open_menu").setDefault(InputDevice.keyboard, Keyboard.KEY_N);
    public OptionsPage optionsPage;
    public final KeyBinding[] keyBindings = new KeyBinding[]{this.keyMute, this.keyPushToTalk, this.keyOpenMenu};
    public OptionFloat voiceChatVolume;
    public OptionBoolean isMuted;
    public OptionBoolean usePushToTalk;
    public OptionBoolean showWaveform;
    public OptionBoolean showMicStatus;
    public OptionString selectedInputDevice;
    public OptionFloat muffleIntensity;
    public OptionEnum<AttenuationProfile> attenuationProfile;
    public OptionEnum<Waveforms.types> waveformType;
    public Option<?>[] options;
    public Path optionFilePath;
    private boolean attenuationProfileChanged = false;
    public EnvironmentDescriptor descriptor;

    public boolean isDisconnected() {
        return !this.client.isMultiplayerWorld() || this.serverAddress == null;
    }

    public void onInitializeClient() {
        ClientEvents.START.add(this::start);
        ClientEvents.STOP.add(this::stop);
        ClientEvents.TICK.add(this::tick);
        ClientEvents.RENDER.add(this::render);
        ClientEvents.LOGIN.add(this::login);
        ClientEvents.DISCONNECT.add(this::disconnect);
    }

    private void start(Minecraft client) {
        instance = this;
        this.client = client;
        this.voiceChatVolume = new OptionFloat(client.gameSettings, "sound.voice_chat", 1.0f);
        this.isMuted = new OptionBoolean(client.gameSettings, "is_muted", false);
        this.usePushToTalk = new OptionBoolean(client.gameSettings, "use_push_to_talk", false);
        this.showWaveform = new OptionBoolean(client.gameSettings, "show_waveform", true);
        this.showMicStatus = new OptionBoolean(client.gameSettings, "show_mic_status", true);
        this.selectedInputDevice = new OptionString(client.gameSettings, "selected_input_device", null);
        this.muffleIntensity = new OptionFloat(client.gameSettings, "muffle_intensity", 1.0f);
        this.attenuationProfile = new OptionEnum(client.gameSettings, "attenuation_profile", AttenuationProfile.class, (Enum)AttenuationProfile.VOICE_CLARITY);
        this.attenuationProfile.addCallback(value -> {
            this.attenuationProfileChanged = true;
        });
        this.waveformType = new OptionEnum(client.gameSettings, "waveform_type", Waveforms.types.class, (Enum)Waveforms.types.BASIC);
        this.options = new Option[]{this.voiceChatVolume, this.isMuted, this.usePushToTalk, this.selectedInputDevice, this.muffleIntensity, this.showWaveform, this.showMicStatus, this.attenuationProfile, this.waveformType};
        this.optionFilePath = FabricLoader.getInstance().getConfigDir().resolve("proxvc_client.properties");
        OptionStore.loadOptions(this.optionFilePath, this.options, this.keyBindings);
        OptionStore.saveOptions(this.optionFilePath, this.options, this.keyBindings);
        try {
            this.socket = new DatagramSocket();
            this.device = new AudioInputDevice();
            this.serverAddress = null;
            this.inputThread = new Thread(new VCInputClient(this));
            this.outputThread = new Thread(new VCOutputClient(this));
            this.inputThread.start();
            this.outputThread.start();
            OptionsCategory generalCategory = new OptionsCategory("gui.options.page.proxvc.category.general", Items.RECORD_CAT.getDefaultStack()).withComponent((OptionsComponent)new FloatOptionComponent(this.voiceChatVolume)).withComponent((OptionsComponent)new ToggleableOptionComponent(this.attenuationProfile)).withComponent((OptionsComponent)new BooleanOptionComponent(this.isMuted)).withComponent((OptionsComponent)new BooleanOptionComponent(this.usePushToTalk));
            OptionsCategory devicesCategory = new OptionsCategory("gui.options.page.proxvc.category.devices", Items.REPEATER.getDefaultStack()).withComponent((OptionsComponent)new MicrophoneListComponent(this.device, this.selectedInputDevice));
            OptionsCategory controlsCategory = new OptionsCategory("gui.options.page.proxvc.category.controls", Items.AMMO_ARROW.getDefaultStack()).withComponent((OptionsComponent)new KeyBindingComponent(this.keyMute)).withComponent((OptionsComponent)new KeyBindingComponent(this.keyPushToTalk)).withComponent((OptionsComponent)new KeyBindingComponent(this.keyOpenMenu));
            OptionsCategory hudCategory = new OptionsCategory("gui.options.page.proxvc.category.hud", Blocks.GLASS.getDefaultStack()).withComponent((OptionsComponent)new ToggleableOptionComponent(this.waveformType)).withComponent((OptionsComponent)new BooleanOptionComponent(this.showWaveform)).withComponent((OptionsComponent)new BooleanOptionComponent(this.showMicStatus));
            OptionsCategory mixerCategory = new OptionsCategory("gui.options.page.proxvc.category.mixer", Items.DUST_REDSTONE.getDefaultStack()).withComponent((OptionsComponent)new VolumeMixerComponent(this.sources));
            mixerCategory.collapsed = true;
            OptionsCategory effectsCategory = new OptionsCategory("gui.options.page.proxvc.category.effects", Items.AMMO_FIREBALL.getDefaultStack()).withComponent((OptionsComponent)new FloatOptionComponent(this.muffleIntensity));
            this.optionsPage = OptionsPages.register((OptionsPage)new OptionsPage("gui.options.page.proxvc.title", Blocks.NOTEBLOCK.getDefaultStack())).withComponent((OptionsComponent)generalCategory).withComponent((OptionsComponent)mixerCategory).withComponent((OptionsComponent)devicesCategory).withComponent((OptionsComponent)controlsCategory).withComponent((OptionsComponent)effectsCategory).withComponent((OptionsComponent)hudCategory);
            ((HudComponentStatus)HudComponents.INSTANCE.getComponent("mic_status")).setStatusData(this.usePushToTalk, this.isMuted, this.showMicStatus, this.keyPushToTalk, this.device);
            ((HudComponentWaveForm)HudComponents.INSTANCE.getComponent("waveform")).setWaveformData(this.showWaveform, this.device);
            this.device.open((String)this.selectedInputDevice.value);
            MixerStore.load();
            this.descriptor = new EnvironmentDescriptor(client, this.sources);
            System.out.println("ProxVC successfully started.");
        }
        catch (SocketException ex) {
            System.out.println("Failed to start the ProxVC client because of an exception.");
            System.out.println("Continuing without ProxVC.");
            ex.printStackTrace();
        }
    }

    private void stop(Minecraft client) {
        if (this.optionFilePath != null) {
            OptionStore.saveOptions(this.optionFilePath, this.options, this.keyBindings);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.inputThread != null) {
                this.inputThread.join();
            }
            if (this.outputThread != null) {
                this.outputThread.join();
            }
            if (this.device != null) {
                this.device.close();
            }
            MixerStore.save();
        }
        catch (InterruptedException ex) {
            System.out.println("Failed to stop the ProxVC client because of an exception.");
            ex.printStackTrace();
        }
    }

    private void tick(Minecraft client) {
        StreamingAudioSource source;
        if (this.isDisconnected()) {
            return;
        }
        HashSet<Integer> toRemove = new HashSet<Integer>(this.sources.keySet());
        HashSet<Integer> toAdd = new HashSet<Integer>();
        for (Entity entity : client.currentWorld.loadedEntityList) {
            if (!(entity instanceof Player) || entity.id == client.thePlayer.id) continue;
            toRemove.remove(entity.id);
            toAdd.add(entity.id);
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int entityId = (Integer)iterator.next();
            this.sources.get(entityId).close();
            this.sources.remove(entityId);
        }
        iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            int entityId = (Integer)iterator.next();
            if (this.sources.containsKey(entityId)) continue;
            source = new StreamingAudioSource();
            source.volume = MixerStore.getMixerProperty(entityId);
            source.setAttenuationProfile((AttenuationProfile)((Object)this.attenuationProfile.value));
            this.sources.put(entityId, source);
        }
        if (client.currentScreen == null) {
            if (this.keyMute.isPressed()) {
                if (!this.isMutePressed) {
                    this.isMutePressed = true;
                    this.isMuted.value = (Boolean)this.isMuted.value == false;
                }
            } else {
                this.isMutePressed = false;
            }
        }
        if (this.keyOpenMenu.isPressed() && client.currentScreen == null) {
            client.displayScreen((Screen)new ScreenOptions(null, this.optionsPage));
        }
        for (Entity entity : client.currentWorld.loadedEntityList) {
            source = this.sources.get(entity.id);
            if (source == null) continue;
            source.efx.calculateMuffleIntensity(client, (Player)entity, ((Float)this.muffleIntensity.value).floatValue());
            Vec3 headPos = ((Player)entity).getPosition(client.timer.partialTicks, true);
            Vec3 look = entity.getLookAngle();
            AL10.alSource3f((int)source.source, (int)4100, (float)((float)entity.x), (float)((float)entity.y), (float)((float)entity.z));
            AL10.alSource3f((int)source.source, (int)4101, (float)((float)look.x), (float)((float)look.y), (float)((float)look.z));
            AL10.alSource3f((int)source.source, (int)4102, (float)((float)entity.xd), (float)((float)entity.yd), (float)((float)entity.zd));
            AL10.alSourcef((int)source.source, (int)4106, (float)(((Float)this.voiceChatVolume.value).floatValue() * source.volume));
            if (!this.attenuationProfileChanged) continue;
            source.setAttenuationProfile((AttenuationProfile)((Object)this.attenuationProfile.value));
        }
        if (this.attenuationProfileChanged) {
            this.attenuationProfileChanged = false;
        }
    }

    private void render(Minecraft client, WorldRenderer renderer) {
    }

    private void login(Minecraft client, PacketLogin packet) {
        Socket socket = client.getSendQueue().netManager.socket;
        this.serverAddress = socket.getRemoteSocketAddress();
    }

    private void disconnect(Minecraft client) {
        this.serverAddress = null;
        for (StreamingAudioSource source : this.sources.values()) {
            source.close();
        }
        this.sources.clear();
    }
}

