/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.gui;

import fiveavian.proxvc.util.Waveforms;
import fiveavian.proxvc.vc.AudioInputDevice;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.option.OptionBoolean;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;

public class HudComponentWaveForm
extends HudComponentMovable {
    private OptionBoolean showWaveform;
    private AudioInputDevice device;
    private Minecraft mc;

    public HudComponentWaveForm(String key, Layout layout) {
        super(key, 100, 15, layout);
    }

    public void setWaveformData(OptionBoolean showWaveform, AudioInputDevice device) {
        this.showWaveform = showWaveform;
        this.device = device;
    }

    public boolean isVisible(Minecraft minecraft) {
        return minecraft.gameSettings.immersiveMode.drawOverlays() && (Boolean)this.showWaveform.value != false;
    }

    public void render(Minecraft mc, HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        if (this.mc == null) {
            this.mc = mc;
        }
        int x = this.getLayout().getComponentX(mc, (HudComponent)this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, (HudComponent)this, ySizeScreen);
        this.drawBackground(x, y, x + 100, y + 15);
        Waveforms.renderWaveformStyle(Waveforms.types.BASIC, this.device.points, x + 2, y, 96.0f, 13.0f, 1.0f, false, null);
    }

    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = this.getLayout().getComponentX(mc, (HudComponent)this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, (HudComponent)this, ySizeScreen);
        gui.drawRect(x, y, x + 100, y + 15, Integer.MIN_VALUE);
        Waveforms.renderWaveformStyle(Waveforms.types.BASIC, null, x + 2, y, 96.0f, 13.0f, 1.0f, false, null);
    }

    private int[] drawBackground(int minX, int minY, int maxX, int maxY) {
        if (this.mc.gameSettings.tooltipStyle.value == TooltipStyle.MODERN) {
            return this.drawBackgroundModern(minX, minY, maxX, maxY);
        }
        int bottomLeftCornerY = maxY - 7;
        int topRightCornerX = maxX - 7;
        int bottomRightCornerX = maxX - 7;
        int bottomRightCornerY = maxY - 7;
        int horWidth = maxX - minX - 14;
        int vertHeight = maxY - minY - 14;
        int horWidth2 = maxX - minX - 6;
        int vertHeight2 = maxY - minY - 6;
        Tessellator tl = Tessellator.instance;
        this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture(TooltipStyle.CRT.getFilePath()));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tl.startDrawingQuads();
        tl.drawRectangleWithUV(minX, minY, 7, 7, 0.0, 0.0, 0.21875, 0.21875);
        tl.drawRectangleWithUV(minX, bottomLeftCornerY, 7, 7, 0.0, 0.21875, 0.21875, 0.21875);
        tl.drawRectangleWithUV(topRightCornerX, minY, 7, 7, 0.21875, 0.0, 0.21875, 0.21875);
        tl.drawRectangleWithUV(bottomRightCornerX, bottomRightCornerY, 7, 7, 0.21875, 0.21875, 0.21875, 0.21875);
        for (int x = minX + 7; x < minX + 7 + horWidth / 11 * 11; x += 11) {
            tl.drawRectangleWithUV(x, minY, 11, 3, 0.4375, 0.0, 0.34375, 0.09375);
        }
        int finalWidth = horWidth - horWidth / 11 * 11;
        tl.drawRectangleWithUV(topRightCornerX - finalWidth, minY, finalWidth, 3, 0.4375, 0.0, (double)((float)finalWidth / 32.0f), 0.09375);
        for (int x = minX + 7; x < minX + 7 + horWidth / 11 * 11; x += 11) {
            tl.drawRectangleWithUV(x, maxY - 3, 11, 3, 0.4375, 0.34375, 0.34375, 0.09375);
        }
        tl.drawRectangleWithUV(bottomRightCornerX - finalWidth, maxY - 3, finalWidth, 3, 0.4375, 0.34375, (double)((float)finalWidth / 32.0f), 0.09375);
        for (int y = minY + 7; y < minY + 7 + vertHeight / 11 * 11; y += 11) {
            tl.drawRectangleWithUV(minX, y, 3, 11, 0.0, 0.4375, 0.09375, 0.34375);
        }
        int finalHeight = vertHeight - vertHeight / 11 * 11;
        tl.drawRectangleWithUV(minX, bottomLeftCornerY - finalHeight, 3, finalHeight, 0.0, 0.4375, 0.09375, (double)((float)finalHeight / 32.0f));
        for (int y = minY + 7; y < minY + 7 + vertHeight / 11 * 11; y += 11) {
            tl.drawRectangleWithUV(maxX - 3, y, 3, 11, 0.34375, 0.4375, 0.09375, 0.34375);
        }
        tl.drawRectangleWithUV(maxX - 3, bottomRightCornerY - finalHeight, 3, finalHeight, 0.34375, 0.4375, 0.09375, (double)((float)finalHeight / 32.0f));
        for (int x = minX + 3; x < minX + 3 + horWidth2 / 8 * 8; x += 8) {
            for (int y = minY + 3; y < minY + 3 + vertHeight2 / 8 * 8; y += 8) {
                tl.drawRectangleWithUV(x, y, 8, 8, 0.4375, 0.4375, 0.25, 0.25);
            }
        }
        int finalHeight2 = vertHeight2 - vertHeight2 / 8 * 8;
        int finalWidth2 = horWidth2 - horWidth2 / 8 * 8;
        for (int x = minX + 3; x < minX + 3 + horWidth2 / 8 * 8; x += 8) {
            tl.drawRectangleWithUV(x, maxY - 3 - finalHeight2, 8, finalHeight2, 0.4375, 0.4375, 0.25, (double)((float)finalHeight2 / 32.0f));
        }
        for (int y = minY + 3; y < minY + 3 + vertHeight2 / 8 * 8; y += 8) {
            tl.drawRectangleWithUV(maxX - 3 - finalWidth2, y, finalWidth2, 8, 0.4375, 0.4375, (double)((float)finalWidth2 / 32.0f), 0.25);
        }
        tl.drawRectangleWithUV(maxX - 3 - finalWidth2, maxY - 3 - finalHeight2, finalWidth2, finalHeight2, 0.4375, 0.4375, (double)((float)finalWidth / 32.0f), (double)((float)finalWidth2 / 32.0f));
        tl.draw();
        GL11.glDisable((int)3042);
        return new int[]{minX, minY};
    }

    private int[] drawBackgroundModern(int minX, int minY, int maxX, int maxY) {
        int x = minX + 4;
        int y = minY + 4;
        int width = maxX - minX - 8;
        int height = maxY - minY - 8;
        int bgColor = -267386864;
        int lineColorTop = 0x505000FF;
        int lineColorBottom = (lineColorTop & 0xFEFEFE) >> 1 | lineColorTop & 0xFF000000;
        this.drawGradientRect(x - 3, y - 4, x + width + 3, y - 3, bgColor, bgColor);
        this.drawGradientRect(x - 3, y + height + 3, x + width + 3, y + height + 4, bgColor, bgColor);
        this.drawGradientRect(x - 3, y - 3, x + width + 3, y + height + 3, bgColor, bgColor);
        this.drawGradientRect(x - 4, y - 3, x - 3, y + height + 3, bgColor, bgColor);
        this.drawGradientRect(x + width + 3, y - 3, x + width + 4, y + height + 3, bgColor, bgColor);
        this.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, lineColorTop, lineColorBottom);
        this.drawGradientRect(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, lineColorTop, lineColorBottom);
        this.drawGradientRect(x - 3, y - 3, x + width + 3, y - 3 + 1, lineColorTop, lineColorTop);
        this.drawGradientRect(x - 3, y + height + 2, x + width + 3, y + height + 3, lineColorBottom, lineColorBottom);
        return new int[]{x - 3, y - 4};
    }

    public void drawGradientRect(int minX, int minY, int maxX, int maxY, int argb1, int argb2) {
        float a1 = (float)(argb1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(argb1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(argb1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(argb1 & 0xFF) / 255.0f;
        float a2 = (float)(argb2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(argb2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(argb2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(argb2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r1, g1, b1, a1);
        tessellator.addVertex((double)maxX, (double)minY, 0.0);
        tessellator.addVertex((double)minX, (double)minY, 0.0);
        tessellator.setColorRGBA_F(r2, g2, b2, a2);
        tessellator.addVertex((double)minX, (double)maxY, 0.0);
        tessellator.addVertex((double)maxX, (double)maxY, 0.0);
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

