/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.util;

import fiveavian.proxvc.vc.StreamingAudioSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import org.lwjgl.opengl.GL11;

public class EnvironmentDescriptor {
    public final Minecraft client;
    public Map<Integer, StreamingAudioSource> sources;
    private static final List<Vec3> directions = Collections.unmodifiableList(Arrays.asList(Vec3.getPermanentVec3((double)1.0, (double)0.0, (double)0.0), Vec3.getPermanentVec3((double)-1.0, (double)0.0, (double)0.0), Vec3.getPermanentVec3((double)0.0, (double)1.0, (double)0.0), Vec3.getPermanentVec3((double)0.0, (double)-1.0, (double)0.0), Vec3.getPermanentVec3((double)0.0, (double)0.0, (double)1.0), Vec3.getPermanentVec3((double)0.0, (double)0.0, (double)-1.0), Vec3.getPermanentVec3((double)1.0, (double)1.0, (double)0.0), Vec3.getPermanentVec3((double)1.0, (double)-1.0, (double)0.0), Vec3.getPermanentVec3((double)-1.0, (double)1.0, (double)0.0), Vec3.getPermanentVec3((double)-1.0, (double)-1.0, (double)0.0), Vec3.getPermanentVec3((double)1.0, (double)0.0, (double)1.0), Vec3.getPermanentVec3((double)1.0, (double)0.0, (double)-1.0), Vec3.getPermanentVec3((double)-1.0, (double)0.0, (double)1.0), Vec3.getPermanentVec3((double)-1.0, (double)0.0, (double)-1.0), Vec3.getPermanentVec3((double)0.0, (double)1.0, (double)1.0), Vec3.getPermanentVec3((double)0.0, (double)1.0, (double)-1.0), Vec3.getPermanentVec3((double)0.0, (double)-1.0, (double)1.0), Vec3.getPermanentVec3((double)0.0, (double)-1.0, (double)-1.0)));
    private float bouncedBackRays = 0.0f;
    private float escapedRays = 0.0f;
    private float totalDistance = 0.0f;

    public EnvironmentDescriptor(Minecraft client, Map<Integer, StreamingAudioSource> sources) {
        this.client = client;
        this.sources = sources;
    }

    public void scan() {
        Vec3 pos = this.client.thePlayer.getPosition(this.client.timer.partialTicks, true);
        this.bouncedBackRays = 0.0f;
        this.escapedRays = 0.0f;
        this.totalDistance = 0.0f;
        for (Vec3 dir : directions) {
            Vec3 normalizedDir = Vec3.getTempVec3((double)dir.x, (double)dir.y, (double)dir.z).normalize();
            this.trace(pos, normalizedDir, 50, 0);
        }
        System.out.println("Bounced back rays: " + this.bouncedBackRays + "Avg distance: " + this.totalDistance / this.bouncedBackRays);
    }

    public void trace(Vec3 start, Vec3 direction, int maxDistance, int bounces) {
        Vec3 pos = this.client.thePlayer.getPosition(this.client.timer.partialTicks, true);
        if (pos.distanceTo(start) < 0.5) {
            start = pos.add(direction.x * 1.0, direction.y * 1.0, direction.z * 1.0);
        }
        if (bounces > 15) {
            return;
        }
        HitResult hit = this.client.currentWorld.checkBlockCollisionBetweenPoints(start, start.add(direction.x * (double)maxDistance, direction.y * (double)maxDistance, direction.z * (double)maxDistance), true);
        if (hit == null || hit.hitType != HitResult.HitType.TILE) {
            this.escapedRays += 1.0f;
            return;
        }
        Vec3 normal = Vec3.getTempVec3((double)hit.side.getOffsetX(), (double)hit.side.getOffsetY(), (double)hit.side.getOffsetZ());
        float dotProduct = (float)direction.dotProduct(normal);
        Vec3 reflectedDirection = Vec3.getTempVec3((double)(direction.x - (double)(2.0f * dotProduct) * normal.x), (double)(direction.y - (double)(2.0f * dotProduct) * normal.y), (double)(direction.z - (double)(2.0f * dotProduct) * normal.z)).normalize();
        HitResult bounceBackHit = this.client.thePlayer.bb.clip(start, start.add(reflectedDirection.x * (double)maxDistance, reflectedDirection.y * (double)maxDistance, reflectedDirection.z * (double)maxDistance));
        if (bounceBackHit != null) {
            this.totalDistance += (float)pos.distanceTo(start);
            this.bouncedBackRays += 1.0f;
            return;
        }
        this.trace(hit.location, reflectedDirection, maxDistance, bounces + 1);
    }

    public void visualizeRay(Vec3 start, Vec3 direction) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)start.x, (double)start.y, (double)start.z);
        GL11.glVertex3d((double)(start.x + direction.x), (double)(start.y + direction.y), (double)(start.z + direction.z));
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

