/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc;

import fiveavian.proxvc.util.Waveforms;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALUtil;

public class AudioInputDevice
implements AutoCloseable {
    private static final int NUM_DEVICE_BUFFERS = 8;
    private final ByteBuffer samples = BufferUtils.createByteBuffer((int)1024);
    private final IntBuffer ints = BufferUtils.createIntBuffer((int)1);
    private Long device = null;
    private boolean isTalking = false;
    public int[] points;

    public static String[] getSpecifiers() {
        List result = null;
        try {
            result = ALUtil.getStringList((long)0L, (int)784);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result == null ? new String[]{} : result.toArray(new String[0]);
    }

    public synchronized void open(String deviceName) {
        this.close();
        if (deviceName == null || deviceName.isEmpty()) {
            this.device = null;
        } else {
            try {
                this.device = ALC11.alcCaptureOpenDevice((CharSequence)deviceName, (int)16384, (int)4353, (int)4096);
                ALC11.alcCaptureStart((long)this.device);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.device = null;
            }
        }
    }

    public synchronized boolean isClosed() {
        return this.device == null;
    }

    public synchronized ByteBuffer pollSamples() {
        if (this.isClosed()) {
            return null;
        }
        this.ints.rewind();
        int is = ALC10.alcGetInteger((long)this.device, (int)786);
        if (is < 512) {
            return null;
        }
        this.samples.rewind();
        ALC11.alcCaptureSamples((long)this.device, (ByteBuffer)this.samples, (int)512);
        return this.samples;
    }

    public synchronized void setTalk(boolean bool) {
        this.isTalking = bool;
    }

    public synchronized boolean isTalking() {
        if (this.isClosed()) {
            return false;
        }
        return this.isTalking;
    }

    public void gatherInfo(boolean muted) {
        if (muted) {
            this.points = null;
            this.isTalking = false;
            return;
        }
        this.points = Waveforms.getWaveformPoints(this.samples, 20);
        this.isTalking = !this.isSilent(this.samples);
    }

    private boolean isSilent(ByteBuffer samples) {
        if (samples.remaining() < 2) {
            return true;
        }
        for (int i = 0; i < samples.remaining(); i += 2) {
            short sample = samples.getShort(i);
            if (Math.abs(sample) <= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        ALC11.alcCaptureStop((long)this.device);
        ALC11.alcCaptureCloseDevice((long)this.device);
    }
}

