/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc;

import fiveavian.proxvc.util.Waveforms;
import fiveavian.proxvc.vc.AttenuationProfile;
import fiveavian.proxvc.vc.EFX;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;

public class StreamingAudioSource
implements AutoCloseable {
    private static final int NUM_BUFFERS = 8;
    public final int source;
    private final IntBuffer buffers = BufferUtils.createIntBuffer((int)8);
    private int bufferIndex = 0;
    private int numBuffersAvailable = 8;
    public float volume = 1.0f;
    public final EFX efx;
    public int[] lastWaveformPoints = Waveforms.getWaveformPoints(null, 20);

    public StreamingAudioSource() {
        try {
            this.source = AL10.alGenSources();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate OpenAL source. Is OpenAL initialized? Check if your volume is set to 0!", e);
        }
        this.efx = new EFX(this.source);
        AL10.alGenBuffers((IntBuffer)this.buffers);
        AL10.alDistanceModel((int)53251);
        AL10.alSourcef((int)this.source, (int)4131, (float)32.0f);
        AL10.alSourcef((int)this.source, (int)4128, (float)16.0f);
        AL11.alSourcef((int)this.source, (int)4097, (float)100.0f);
        AL11.alSourcef((int)this.source, (int)4098, (float)220.0f);
        AL11.alSourcef((int)this.source, (int)131081, (float)0.5f);
        AL11.alSourcef((int)this.source, (int)4130, (float)0.8f);
    }

    public void queueSamples(ByteBuffer samples) {
        int state;
        int numBuffersToUnqueue = AL10.alGetSourcei((int)this.source, (int)4118);
        this.numBuffersAvailable += numBuffersToUnqueue;
        for (int i = 0; i < numBuffersToUnqueue; ++i) {
            AL10.alSourceUnqueueBuffers((int)this.source);
        }
        if (this.numBuffersAvailable == 0) {
            return;
        }
        AL10.alBufferData((int)this.buffers.get(this.bufferIndex), (int)4353, (ByteBuffer)samples, (int)16384);
        AL10.alSourceQueueBuffers((int)this.source, (int)this.buffers.get(this.bufferIndex));
        if (samples.remaining() > 0) {
            this.lastWaveformPoints = Waveforms.getWaveformPoints(samples, 20);
        }
        if ((state = AL10.alGetSourcei((int)this.source, (int)4112)) != 4114) {
            AL10.alSourcePlay((int)this.source);
        }
        --this.numBuffersAvailable;
        ++this.bufferIndex;
        this.bufferIndex %= 8;
    }

    public void setAttenuationProfile(AttenuationProfile profile) {
        switch (profile) {
            case REALISTIC: {
                AL10.alDistanceModel((int)53253);
                AL10.alSourcef((int)this.source, (int)4129, (float)4.0f);
                AL10.alSourcef((int)this.source, (int)4131, (float)32.0f);
                AL10.alSourcef((int)this.source, (int)4128, (float)16.0f);
                break;
            }
            case VOICE_CLARITY: {
                AL10.alDistanceModel((int)53251);
                AL10.alSourcef((int)this.source, (int)4129, (float)1.0f);
                AL10.alSourcef((int)this.source, (int)4131, (float)32.0f);
                AL10.alSourcef((int)this.source, (int)4128, (float)16.0f);
            }
        }
    }

    @Override
    public void close() {
        this.efx.close();
        AL10.alDeleteSources((int)this.source);
        AL10.alDeleteBuffers((IntBuffer)this.buffers);
    }
}

