/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenMainMenu;
import net.minecraft.core.lang.I18n;

public class ScreenConnectFailed
extends Screen {
    private String errorMessage;
    private String errorDetail;

    public ScreenConnectFailed(String s, String s1, Object[] aobj) {
        String authToken;
        I18n stringtranslate = I18n.getInstance();
        this.errorMessage = stringtranslate.translateKey(s);
        this.errorDetail = aobj != null ? stringtranslate.translateKeyAndFormat(s1, aobj) : stringtranslate.translateKey(s1);
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.session != null && (authToken = mc.session.sessionId) != null && authToken.length() > 1 && this.errorDetail.contains(authToken)) {
            this.errorDetail = this.errorDetail.replace(authToken, "<AUTH TOKEN>");
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        this.buttons.clear();
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.connect_failed.button.back")));
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (button.id == 0) {
            this.mc.displayScreen(new ScreenMainMenu());
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        this.drawStringCentered(this.font, this.errorMessage, this.width / 2, this.height / 2 - 50, 0xFFFFFF);
        this.drawStringCentered(this.font, this.errorDetail, this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }
}

