/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;

public class BlockModelHorizontalRotation<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelHorizontalRotation(Block<T> block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(data & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.overbrightTextures.get(Side.BOTTOM);
        }
        return super.getBlockOverbrightTextureFromSideAndMeta(Side.getSideById(index), data);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(data & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        return super.getBlockTextureFromSideAndMetadata(Side.getSideById(index), data);
    }
}

