/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicLeavesCherryFlowering;
import net.minecraft.core.util.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelLeavesCherryFlowering<T extends BlockLogic>
extends BlockModelLeaves<T> {
    private final IconCoordinate grownCherryOverlay = TextureRegistry.getTexture("minecraft:block/leaves/cherry_overlay");
    private final IconCoordinate floweringCherryOverlay = TextureRegistry.getTexture("minecraft:block/leaves/cherry_flowering_overlay");

    public BlockModelLeavesCherryFlowering(Block<T> block) {
        super(block, "minecraft:block/leaves/cherry");
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        super.render(tessellator, x, y, z);
        int growthRate = BlockLogicLeavesCherryFlowering.getGrowthRate(BlockModelLeavesCherryFlowering.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        BlockModelLeavesCherryFlowering.renderBlocks.overrideBlockTexture = growthRate > 0 ? this.grownCherryOverlay : this.floweringCherryOverlay;
        this.renderStandardBlock(tessellator, this.block.getBoundsRaw(), x, y, z, 1.0f, 1.0f, 1.0f);
        BlockModelLeavesCherryFlowering.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        AABB bounds = this.block.getBoundsRaw();
        IconCoordinate cherryCoord = this.grownCherryOverlay;
        GL11.glColor4f(brightness, brightness, brightness, alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
    }
}

