/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BlockModelPistonHead
extends BlockModelStandard<BlockLogicPistonHead> {
    protected IconCoordinate pistonHead;
    protected IconCoordinate pistonShaft;
    protected IconCoordinate pistonDry = TextureRegistry.getTexture("minecraft:block/piston/face");
    protected IconCoordinate pistonSticky = TextureRegistry.getTexture("minecraft:block/piston_sticky/face");
    protected IconCoordinate pistonSteel = TextureRegistry.getTexture("minecraft:block/piston_steel/face");
    @Nullable
    public IconCoordinate faceTextureOverride;
    protected final double headThickness;
    protected final double shaftThickness;

    public BlockModelPistonHead(Block<BlockLogicPistonHead> block, IconCoordinate pistonHead, IconCoordinate pistonShaft) {
        this(block, pistonHead, pistonShaft, 0.25, 0.25);
    }

    public BlockModelPistonHead(Block<BlockLogicPistonHead> block, IconCoordinate pistonHead, IconCoordinate pistonShaft, double headThickness, double shaftThickness) {
        super(block);
        this.pistonHead = pistonHead;
        this.pistonShaft = pistonShaft;
        this.headThickness = headThickness;
        this.shaftThickness = shaftThickness;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        return this.renderPistonHead(tessellator, this.block, x, y, z, true);
    }

    public void renderPistonHeadNoCulling(Tessellator tessellator, Block<BlockLogicPistonHead> block, int x, int y, int z, boolean flag) {
        BlockModelPistonHead.renderBlocks.renderAllFaces = true;
        this.renderPistonHead(tessellator, block, x, y, z, flag);
        BlockModelPistonHead.renderBlocks.renderAllFaces = false;
    }

    public void setFaceTextureOverride(@Nullable IconCoordinate faceTexture) {
        this.faceTextureOverride = faceTexture;
    }

    protected boolean renderPistonHead(Tessellator tessellator, Block<BlockLogicPistonHead> block, int x, int y, int z, boolean flag) {
        int metadata = BlockModelPistonHead.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction direction = BlockLogicPistonHead.getDirectionFromMeta(metadata);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(block.getLightmapCoord(BlockModelPistonHead.renderBlocks.blockAccess, x, y, z));
        } else {
            brightness = this.getBlockBrightness(BlockModelPistonHead.renderBlocks.blockAccess, x, y, z);
        }
        float f1 = flag ? 1.0f : 0.5f;
        double width = flag ? 1.0 : 0.5;
        switch (direction) {
            case DOWN: {
                BlockModelPistonHead.renderBlocks.uvRotateEast = 3;
                BlockModelPistonHead.renderBlocks.uvRotateWest = 3;
                BlockModelPistonHead.renderBlocks.uvRotateSouth = 3;
                BlockModelPistonHead.renderBlocks.uvRotateNorth = 3;
                this.renderStandardBlock(tessellator, AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0), x, y, z);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness * 0.6f, width);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.6f, width);
                break;
            }
            case UP: {
                this.renderStandardBlock(tessellator, AABB.getTemporaryBB(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0), x, y, z);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness * 0.6f, width);
                this.renderHeadTopBottom(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.6f, width);
                break;
            }
            case NORTH: {
                BlockModelPistonHead.renderBlocks.uvRotateSouth = 1;
                BlockModelPistonHead.renderBlocks.uvRotateNorth = 2;
                this.renderStandardBlock(tessellator, AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness), x, y, z);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness * 0.5f, width);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness, width);
                break;
            }
            case SOUTH: {
                BlockModelPistonHead.renderBlocks.uvRotateSouth = 2;
                BlockModelPistonHead.renderBlocks.uvRotateNorth = 1;
                BlockModelPistonHead.renderBlocks.uvRotateTop = 3;
                BlockModelPistonHead.renderBlocks.uvRotateBottom = 3;
                this.renderStandardBlock(tessellator, AABB.getTemporaryBB(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0), x, y, z);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 - this.shaftThickness / 2.0, (double)x + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness * 0.5f, width);
                this.renderHeadNorthSouth(tessellator, (double)x + 0.5 + this.shaftThickness / 2.0, (double)x + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness, width);
                break;
            }
            case WEST: {
                BlockModelPistonHead.renderBlocks.uvRotateEast = 1;
                BlockModelPistonHead.renderBlocks.uvRotateWest = 2;
                BlockModelPistonHead.renderBlocks.uvRotateTop = 2;
                BlockModelPistonHead.renderBlocks.uvRotateBottom = 1;
                this.renderStandardBlock(tessellator, AABB.getTemporaryBB(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0), x, y, z);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.5f, width);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness, width);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.6f, width);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness * 0.6f, width);
                break;
            }
            case EAST: {
                BlockModelPistonHead.renderBlocks.uvRotateEast = 2;
                BlockModelPistonHead.renderBlocks.uvRotateWest = 1;
                BlockModelPistonHead.renderBlocks.uvRotateTop = 1;
                BlockModelPistonHead.renderBlocks.uvRotateBottom = 2;
                this.renderStandardBlock(tessellator, AABB.getTemporaryBB(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0), x, y, z);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.5f, width);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness, width);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 - this.shaftThickness / 2.0, brightness * 0.6f, width);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (double)y + 0.5 + this.shaftThickness / 2.0, (double)y + 0.5 - this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, (double)z + 0.5 + this.shaftThickness / 2.0, brightness * 0.6f, width);
            }
        }
        this.resetRenderBlocks();
        return true;
    }

    private void renderHeadTopBottom(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = BlockModelPistonHead.renderBlocks.overrideBlockTexture != null ? BlockModelPistonHead.renderBlocks.overrideBlockTexture : this.pistonShaft;
        double uMin = i.getSubIconU(0.5 - this.shaftThickness / 2.0);
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(0.5 + this.shaftThickness / 2.0);
        double vMax = i.getSubIconV(width);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMin, yMax, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMax);
    }

    private void renderHeadNorthSouth(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = BlockModelPistonHead.renderBlocks.overrideBlockTexture != null ? BlockModelPistonHead.renderBlocks.overrideBlockTexture : this.pistonShaft;
        double uMin = i.getSubIconU(0.5 - this.shaftThickness / 2.0);
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(0.5 + this.shaftThickness / 2.0);
        double vMax = i.getSubIconV(width);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yMax, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMax);
    }

    private void renderHeadEastWest(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = BlockModelPistonHead.renderBlocks.overrideBlockTexture != null ? BlockModelPistonHead.renderBlocks.overrideBlockTexture : this.pistonShaft;
        double uMin = i.getSubIconU(0.5 - this.shaftThickness / 2.0);
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(0.5 + this.shaftThickness / 2.0);
        double vMax = i.getSubIconV(width);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yMax, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMax);
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        boolean isSteel;
        Direction direction = BlockLogicPistonHead.getDirectionFromMeta(data);
        if (side.getDirection() == direction) {
            if (this.faceTextureOverride != null) {
                return this.faceTextureOverride;
            }
            switch (BlockLogicPistonHead.getPistonType(data)) {
                case 0: {
                    return this.pistonDry;
                }
                case 1: {
                    return this.pistonSticky;
                }
                case 2: {
                    return this.pistonSteel;
                }
            }
        }
        boolean bl = isSteel = this.block == Blocks.PISTON_HEAD_STEEL;
        return side.getDirection() != direction.getOpposite() ? this.pistonHead : (isSteel ? this.pistonSteel : this.pistonDry);
    }
}

