/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import java.util.Arrays;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelStandard<T extends BlockLogic>
extends BlockModel<T> {
    public static final IconCoordinate BLOCK_TEXTURE_MISSING = TextureRegistry.getTexture("minecraft:block/texture_missing");
    public static final IconCoordinate BLOCK_TEXTURE_UNASSIGNED = TextureRegistry.getTexture("minecraft:block/texture_unassigned");
    @Nullable
    public AABB itemRenderBounds = null;
    public int renderLayer = 0;
    public static final int BLOCK_TEXTURES = 0;
    public static final int OVERBRIGHT_TEXTURES = 1;
    public static final int RETRO_BLOCK_TEXTURES = 2;
    public static final int RETRO_OVERBRIGHT_TEXTURES = 3;
    protected final TextureLayer blockTextures = new TextureLayer().setAll(BLOCK_TEXTURE_UNASSIGNED);
    protected final TextureLayer overbrightTextures = new TextureLayer();
    protected final TextureLayer retroBlockTextures = new TextureLayer();
    protected final TextureLayer retroOverbrightTextures = new TextureLayer();

    public BlockModelStandard(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        return this.renderStandardBlock(tessellator, this.block.getBlockBoundsFromState(BlockModelStandard.renderBlocks.blockAccess, x, y, z), x, y, z);
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelStandard.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f(r * brightness, g * brightness, b * brightness, alpha);
        } else {
            GL11.glColor4f(brightness, brightness, brightness, alpha);
        }
        float yOffset = 0.5f;
        AABB bounds = this.getBlockBoundsForItemRender();
        GL11.glTranslatef(-0.5f, 0.0f - yOffset, -0.5f);
        this.renderBlockWithBounds(tessellator, bounds, metadata, brightness, alpha, lightmapCoordinate);
        GL11.glTranslatef(0.5f, yOffset, 0.5f);
    }

    public void renderBlockWithBounds(Tessellator tessellator, AABB bounds, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (LightmapHelper.isLightmapEnabled() && lightmapCoordinate != null) {
            LightmapHelper.setLightmapCoord(lightmapCoordinate);
        }
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.draw();
        if (this.hasOverbright()) {
            brightness = 1.0f;
            if (BlockModelStandard.renderBlocks.useInventoryTint) {
                int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f(r * brightness, g * brightness, b * brightness, alpha);
            } else {
                GL11.glColor4f(brightness, brightness, brightness, alpha);
            }
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(15, 15);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.BOTTOM, metadata));
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.TOP, metadata));
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.NORTH, metadata));
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.SOUTH, metadata));
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.WEST, metadata));
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.EAST, metadata));
            tessellator.draw();
        }
    }

    @Override
    public boolean shouldItemRender3d() {
        return true;
    }

    @Override
    public float getItemRenderScale() {
        return 0.25f;
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.getBlockTextureFromSideAndMetadata(side, blockAccess.getBlockMetadata(x, y, z));
    }

    @Override
    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        return this.getBlockOverbrightTextureFromSideAndMeta(Side.getSideById(side), blockAccess.getBlockMetadata(x, y, z));
    }

    @Override
    public boolean hasOverbright() {
        return this.overbrightTextures.hasTexture();
    }

    @Override
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        if (this.retroOverbrightTextures.hasTexture && this.isRetro()) {
            return this.retroOverbrightTextures.get(side);
        }
        return this.overbrightTextures.get(side);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (this.retroBlockTextures.hasTexture && this.isRetro()) {
            return this.retroBlockTextures.get(side);
        }
        return this.blockTextures.get(side);
    }

    @Override
    public IconCoordinate getParticleTexture(Side side, int meta) {
        return this.getBlockTextureFromSideAndMetadata(side, meta);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, int side, int meta) {
        return this.shouldSideBeRendered(blockAccess, bounds, x, y, z, side);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, int side) {
        Side side1 = Side.getSideById(side);
        if (side1 == Side.BOTTOM && bounds.minY > 0.0) {
            return true;
        }
        if (side1 == Side.TOP && bounds.maxY < 1.0) {
            return true;
        }
        if (side1 == Side.NORTH && bounds.minZ > 0.0) {
            return true;
        }
        if (side1 == Side.SOUTH && bounds.maxZ < 1.0) {
            return true;
        }
        if (side1 == Side.WEST && bounds.minX > 0.0) {
            return true;
        }
        if (side1 == Side.EAST && bounds.maxX < 1.0) {
            return true;
        }
        return !blockAccess.isBlockOpaqueCube(x, y, z);
    }

    @Override
    public boolean shouldSideBeColored(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        return true;
    }

    @Override
    public AABB getBlockBoundsForItemRender() {
        if (this.itemRenderBounds != null) {
            return this.itemRenderBounds;
        }
        return super.getBlockBoundsForItemRender();
    }

    @Override
    public int renderLayer() {
        return this.renderLayer;
    }

    public BlockModelStandard<T> onRenderLayer(int layer) {
        this.renderLayer = layer;
        return this;
    }

    public BlockModelStandard<T> withCustomItemBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.itemRenderBounds = AABB.getPermanentBB(minX, minY, minZ, maxX, maxY, maxZ);
        return this;
    }

    public BlockModelStandard<T> setTex(int layer, @Nullable IconCoordinate coordinate, Side ... sides) {
        switch (layer) {
            case 0: {
                this.blockTextures.set(coordinate, sides);
                break;
            }
            case 1: {
                this.overbrightTextures.set(coordinate, sides);
                break;
            }
            case 2: {
                this.retroBlockTextures.set(coordinate, sides);
                break;
            }
            case 3: {
                this.retroOverbrightTextures.set(coordinate, sides);
            }
        }
        return this;
    }

    public BlockModelStandard<T> setTex(int layer, @Nullable String texture, Side ... sides) {
        switch (layer) {
            case 0: {
                this.blockTextures.set(texture, sides);
                break;
            }
            case 1: {
                this.overbrightTextures.set(texture, sides);
                break;
            }
            case 2: {
                this.retroBlockTextures.set(texture, sides);
                break;
            }
            case 3: {
                this.retroOverbrightTextures.set(texture, sides);
            }
        }
        return this;
    }

    public BlockModelStandard<T> setAllTextures(int layer, @Nullable IconCoordinate coordinate) {
        switch (layer) {
            case 0: {
                this.blockTextures.setAll(coordinate);
                break;
            }
            case 1: {
                this.overbrightTextures.setAll(coordinate);
                break;
            }
            case 2: {
                this.retroBlockTextures.setAll(coordinate);
                break;
            }
            case 3: {
                this.retroOverbrightTextures.setAll(coordinate);
            }
        }
        return this;
    }

    public BlockModelStandard<T> setAllTextures(int layer, @Nullable String texture) {
        switch (layer) {
            case 0: {
                this.blockTextures.setAll(texture);
                break;
            }
            case 1: {
                this.overbrightTextures.setAll(texture);
                break;
            }
            case 2: {
                this.retroBlockTextures.setAll(texture);
                break;
            }
            case 3: {
                this.retroOverbrightTextures.setAll(texture);
            }
        }
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withOverbrightTexture(String texture) {
        this.overbrightTextures.setAll(texture);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String texture) {
        this.blockTextures.setAll(texture);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String textureTopBottom, String textureSides) {
        this.blockTextures.set(textureTopBottom, Side.TOP, Side.BOTTOM).set(textureSides, Side.NORTH, Side.EAST, Side.SOUTH, Side.WEST);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String textureTop, String textureBottom, String textureSides) {
        this.blockTextures.set(textureTop, Side.TOP).set(textureBottom, Side.BOTTOM).set(textureSides, Side.NORTH, Side.EAST, Side.SOUTH, Side.WEST);
        return this;
    }

    @Deprecated
    public BlockModelStandard<T> withTextures(String textureTop, String textureBottom, String textureNorth, String textureEast, String textureSouth, String textureWest) {
        this.blockTextures.set(textureTop, Side.TOP).set(textureBottom, Side.BOTTOM).set(textureNorth, Side.NORTH).set(textureEast, Side.EAST).set(textureSouth, Side.SOUTH).set(textureWest, Side.WEST);
        return this;
    }

    protected static class TextureLayer {
        private final @Nullable IconCoordinate @NotNull [] coordinates = new IconCoordinate[6];
        private boolean hasTexture = false;

        protected TextureLayer() {
        }

        public TextureLayer set(@Nullable IconCoordinate coordinate, Side ... sides) {
            for (Side s : sides) {
                assert (s != Side.NONE) : "Cannot set texture on a 'NONE' side!";
                this.coordinates[s.getId()] = coordinate;
            }
            this.hasTexture = false;
            for (IconCoordinate iconCoordinate : this.coordinates) {
                this.hasTexture |= iconCoordinate != null;
            }
            return this;
        }

        public TextureLayer set(@Nullable String texture, Side ... sides) {
            return this.set(texture == null ? null : TextureRegistry.getTexture(texture), sides);
        }

        public TextureLayer setAll(@Nullable IconCoordinate coordinate) {
            Arrays.fill(this.coordinates, coordinate);
            this.hasTexture = coordinate != null;
            return this;
        }

        public TextureLayer setAll(@Nullable String texture) {
            return this.setAll(texture == null ? null : TextureRegistry.getTexture(texture));
        }

        public TextureLayer copy(@NotNull TextureLayer layer) {
            System.arraycopy(layer.coordinates, 0, this.coordinates, 0, 6);
            this.hasTexture = layer.hasTexture;
            return this;
        }

        @Nullable
        public IconCoordinate get(@NotNull Side side) {
            assert (side != Side.NONE) : "Cannot set texture on a 'NONE' side!";
            return this.coordinates[side.getId()];
        }

        @Nullable
        public IconCoordinate get(int index) {
            assert (index >= 0) : "Index must be greater then or equal to 0!";
            assert (index < this.coordinates.length) : "Index must be less then " + this.coordinates.length + "!";
            return this.coordinates[index];
        }

        public boolean hasTexture() {
            return this.hasTexture;
        }
    }
}

