/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;

public class BlockLogicDeadBush
extends BlockLogicFlower {
    public BlockLogicDeadBush(Block<?> block) {
        super(block);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 0.8f, 0.5f + f);
    }

    @Override
    public boolean mayPlaceOn(int blockId) {
        return blockId == Blocks.SAND.id() || blockId == Blocks.DIRT_SCORCHED.id() || BlockTags.GROWS_FLOWERS.appliesTo(Blocks.getBlock(blockId));
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        int quantity = world.rand.nextInt(3);
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        if (quantity == 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Items.STICK, quantity)};
    }
}

