/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta.worldloader;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import net.minecraft.core.world.save.DimensionData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DimensionDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Nullable
    public static DimensionData getDimensionData(@NotNull File worldDir, int dimensionId) {
        Objects.requireNonNull(worldDir, "WorldDir must not be null!");
        CompoundTag tag = DimensionDataLoader.getDimensionDataRaw(worldDir, dimensionId);
        if (tag == null) {
            return null;
        }
        return new DimensionData(tag);
    }

    @Nullable
    public static CompoundTag getDimensionDataRaw(@NotNull File worldDir, int dimensionId) {
        if (!worldDir.exists()) {
            return null;
        }
        File dimensionsDir = new File(worldDir, "dimensions");
        File dimensionDir = new File(dimensionsDir, "" + dimensionId);
        File dimensionDat = new File(dimensionDir, "dimension.dat");
        if (dimensionDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
                return nbtRoot.getCompound("Data");
            }
            catch (Exception ex) {
                LOGGER.error("Error parsing 'dimension.dat' in '{}' dimension {}", worldDir, dimensionId, ex);
            }
        }
        if ((dimensionDat = new File(dimensionDir, "dimension.dat_old")).exists()) {
            try {
                CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
                return oldNbtRoot.getCompound("Data");
            }
            catch (Exception ex) {
                LOGGER.error("Error parsing 'dimension.dat_old' in '{}' dimension {}", worldDir, dimensionId, ex);
            }
        }
        return null;
    }
}

