/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether;

import com.b100.utils.FileUtils;
import com.b100.utils.StreamUtils;
import com.b100.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.net.CertificateHelper;
import teamport.aether.AetherConfig;
import teamport.aether.AetherMod;
import teamport.aether.helper.Pair;

@Environment(value=EnvType.CLIENT)
public class AetherRemoteResourceDownloaderThread
extends Thread {
    public final Minecraft mc;
    public File resourcesFolder;
    public AtomicInteger progress;
    public volatile int toDownload = 0;
    public volatile State state;
    private final String URL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AetherRemoteResourceDownloaderThread(File file, Minecraft minecraft) {
        super("Aether Resource Download");
        this.mc = minecraft;
        this.progress = new AtomicInteger(0);
        this.setDaemon(true);
        this.state = State.IDLE;
        this.resourcesFolder = new File(file, "resources/");
        if (!this.resourcesFolder.exists() && !this.resourcesFolder.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + this.resourcesFolder);
        }
        Object object = AetherConfig.CONFIGURATION_LOCK;
        synchronized (object) {
            this.URL = AetherConfig.REMOTE_RESOURCE_URL;
        }
    }

    @Override
    public void run() {
        String key;
        JsonArray manifest;
        try {
            String manifestURL = this.URL + "manifest.json";
            manifest = JsonParser.parseString((String)StringUtils.getWebsiteContentAsString((String)manifestURL)).getAsJsonArray();
            AetherMod.LOGGER.info("Manifest Downloaded");
        }
        catch (Exception except) {
            this.state = State.ERROR;
            AetherMod.LOGGER.error("Failed to fetch resource manifest.");
            return;
        }
        List entries = manifest.asList();
        ArrayList<Pair<File, String>> entriesToDownload = new ArrayList<Pair<File, String>>();
        for (JsonElement jsonElement : entries) {
            boolean fileAlreadyDownloaded;
            File soundFile;
            block18: {
                if (!(jsonElement instanceof JsonObject)) continue;
                JsonObject entryObj = (JsonObject)jsonElement;
                key = entryObj.get("Key").getAsString();
                String md5 = entryObj.get("MD5").getAsString();
                soundFile = new File(this.resourcesFolder, key);
                fileAlreadyDownloaded = false;
                try {
                    byte[] localFileMD5;
                    if (!soundFile.exists()) break block18;
                    Path localfilePath = soundFile.toPath();
                    try (InputStream fileHandle = Files.newInputStream(localfilePath, new OpenOption[0]);){
                        byte[] fileData = new byte[(int)Files.size(localfilePath)];
                        fileHandle.read(fileData);
                        localFileMD5 = MessageDigest.getInstance("MD5").digest(fileData);
                    }
                    byte[] remoteFileMD5 = new BigInteger(md5, 16).toByteArray();
                    if (remoteFileMD5[0] == 0) {
                        byte[] newBytes = new byte[remoteFileMD5.length - 1];
                        System.arraycopy(remoteFileMD5, 1, newBytes, 0, newBytes.length);
                        remoteFileMD5 = newBytes;
                    }
                    if (Arrays.equals(remoteFileMD5, localFileMD5)) {
                        fileAlreadyDownloaded = true;
                    }
                }
                catch (Exception e) {
                    AetherMod.LOGGER.error("Failed to assess local file: {}", (Object)soundFile);
                }
            }
            if (fileAlreadyDownloaded) {
                AetherMod.LOGGER.info("File Already Downloaded: {}", (Object)soundFile);
                continue;
            }
            entriesToDownload.add(new Pair<File, String>(soundFile, key));
        }
        this.toDownload = entriesToDownload.size();
        if (this.toDownload > 0) {
            this.state = State.DOWNLOADING;
            for (Pair pair : entriesToDownload) {
                File soundFile = (File)pair.first;
                key = (String)pair.second;
                try {
                    this.downloadSoundFile(key, soundFile);
                }
                catch (Exception e) {
                    AetherMod.LOGGER.error("Failed to download File: {}", (Object)key);
                }
                this.progress.incrementAndGet();
            }
            AetherMod.LOGGER.info("Finished Downloading files!");
            SoundRepository.reload();
            this.mc.sndManager.destroy();
            this.mc.sndManager = new SoundEngine();
            this.mc.sndManager.init(this.mc.gameSettings);
            this.state = State.IDLE;
        }
    }

    private void downloadSoundFile(String name, File file) throws Exception {
        String url = this.URL + name;
        url = url.replace(" ", "%20");
        AetherMod.LOGGER.info("Downloading File: {}", (Object)url);
        StreamUtils.transferDataAndClose((InputStream)new BufferedInputStream(CertificateHelper.getWebsiteAsStream((String)url)), (OutputStream)new BufferedOutputStream(Files.newOutputStream(FileUtils.createNewFile((File)file).toPath(), new OpenOption[0])));
    }

    @Environment(value=EnvType.CLIENT)
    public static enum State {
        IDLE,
        DOWNLOADING,
        ERROR;

    }
}

