/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.compat.waila;

import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import teamport.aether.entity.tile.TileEntityIncubator;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;
import toufoumaster.btwaila.util.ProgressBarOptions;
import toufoumaster.btwaila.util.TextureOptions;

public class IncubatorTooltip
extends TileTooltip<TileEntityIncubator> {
    public void initTooltip() {
        this.addClass(TileEntityIncubator.class);
    }

    public void drawAdvancedTooltip(TileEntityIncubator incubator, AdvancedInfoComponent advancedInfoComponent) {
        ItemStack input = incubator.getItem(0);
        ItemStack fuel = incubator.getItem(1);
        ProgressBarOptions options = new ProgressBarOptions(0, String.format("%s%s%s ", TextFormatting.ORANGE, BTWaila.translator.translateKey("aether.tooltip.incubator.progress"), TextFormatting.RESET), true, true, new TextureOptions(0xFFFFFF, TextureRegistry.getTexture((String)"aether:extras/incubator_bg")), new TextureOptions(0xFFFFFF, TextureRegistry.getTexture((String)"aether:extras/incubator_fg")));
        advancedInfoComponent.drawProgressBarTextureWithText(incubator.getProcessProgressScaled(100), 100, options, 0);
        advancedInfoComponent.drawStringWithShadow(String.format(BTWaila.translator.translateKey("aether.tooltip.machine.energy"), incubator.currentEnergyTime / 20), 0);
        ItemStack[] stacks = new ItemStack[]{input, fuel};
        advancedInfoComponent.drawItemList(stacks, 0);
    }
}

