/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.animal.Creature;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import teamport.aether.blocks.AetherBlockTags;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.AetherDeathMessage;

public abstract class MobAetherAnimal
extends MobAnimal
implements Creature,
AetherDeathMessage {
    public MobAetherAnimal(World world) {
        super(world);
        this.scoreValue = 10;
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public float getBlockPathWeight(int x, int y, int z) {
        return this.world.getBlockId(x, y - 1, z) == AetherBlocks.GRASS_AETHER.id() ? 10.0f : this.world.getLightBrightness(x, y, z) - 0.5f;
    }

    public boolean canSpawnHere() {
        int z;
        int y;
        int x = MathHelper.floor((double)this.x);
        int id = this.world.getBlockId(x, (y = MathHelper.floor((double)this.bb.minY)) - 1, z = MathHelper.floor((double)this.z));
        if (Blocks.blocksList[id] == null) {
            return false;
        }
        return Blocks.blocksList[id].hasTag(AetherBlockTags.PASSIVE_MOBS_SPAWN) && this.world.getFullBlockLightValue(x, y, z) > 8;
    }
}

