/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import teamport.aether.entity.AetherJumpAmount;
import teamport.aether.entity.AetherRideable;
import teamport.aether.entity.animal.MobAetherAnimal;
import teamport.aether.mixin.accessors.EntityAccessor;
import teamport.aether.net.message.AetherRideableNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class MobAetherAnimalRideable
extends MobAetherAnimal
implements AetherRideable,
AetherJumpAmount {
    protected int jumpsRemaining = this.getJumpMaxAmount();
    protected int maxJumps = 3;
    protected boolean jumpPressed;
    public float rideFootSize;
    protected double xdChange = 0.0;
    protected double zdChange = 0.0;
    protected boolean playerUsedJump = false;

    public MobAetherAnimalRideable(World world) {
        super(world);
    }

    public void tick() {
        super.tick();
        this.onGround();
        this.vehicleMovement();
    }

    @Override
    public int getJumpMaxAmount() {
        return this.maxJumps;
    }

    @Override
    public int getJumpAmount() {
        return this.jumpsRemaining;
    }

    @Override
    public void controlEntity(float moveForward, float moveStrafe, boolean isJumping, float xRot, float yRot) {
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new AetherRideableNetworkMessage(moveForward, moveStrafe, isJumping, xRot, yRot));
        }
        float yawDeg = (float)((double)yRot * (Math.PI / 180));
        float step = 0.175f;
        if (moveForward > 0.1f) {
            this.xdChange += (double)moveForward * -Math.sin(yawDeg) * (double)step;
            this.zdChange += (double)moveForward * Math.cos(yawDeg) * (double)step;
        } else if (moveForward < -0.1f) {
            this.xdChange += (double)moveForward * -Math.sin(yawDeg) * (double)step;
            this.zdChange += (double)moveForward * Math.cos(yawDeg) * (double)step;
        }
        if (moveStrafe > 0.1f) {
            this.xdChange += (double)moveStrafe * Math.cos(yawDeg) * (double)step;
            this.zdChange += (double)moveStrafe * Math.sin(yawDeg) * (double)step;
        } else if (moveStrafe < -0.1f) {
            this.xdChange += (double)moveStrafe * Math.cos(yawDeg) * (double)step;
            this.zdChange += (double)moveStrafe * Math.sin(yawDeg) * (double)step;
        }
        if (isJumping && !this.jumpPressed) {
            this.playerUsedJump = true;
            this.jumpPressed = true;
        }
        if (this.jumpPressed && !isJumping) {
            this.jumpPressed = false;
        }
    }

    public void vehicleMovement() {
        if (this.passenger == null || !(this.passenger instanceof Player)) {
            return;
        }
        Player player = (Player)this.passenger;
        player.handleSpecialVehicleControl();
        this.xd += this.xdChange;
        this.zd += this.zdChange;
        this.xdChange = 0.0;
        this.zdChange = 0.0;
        if (this.playerUsedJump) {
            boolean canJump;
            boolean bl = canJump = this.jumpsRemaining > 0;
            if (this.onGround) {
                this.yd = 1.4;
                this.onGround = false;
            } else {
                if (this.isInWater()) {
                    this.yd = 0.5;
                } else if (canJump) {
                    this.yd = 1.2;
                }
                --this.jumpsRemaining;
            }
            if ((this.isInWater() || canJump) && !this.world.isClientSide) {
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.wingflap", 2.0f, 1.0f);
            }
        }
        this.playerUsedJump = false;
        player.sendSpecialVehiclePacket();
        double horizontalSpeed = Math.abs(Math.sqrt(this.xd * this.xd + this.zd * this.zd));
        if (horizontalSpeed > 0.375) {
            double normal = 0.375 / horizontalSpeed;
            this.xd *= normal;
            this.zd *= normal;
        }
    }

    public void updateAI() {
        if (this.passenger != null && this.passenger instanceof Player) {
            this.moveSpeed = 0.0f;
            this.moveStrafing = 0.0f;
            this.isJumping = false;
            this.footSize = this.rideFootSize;
            this.yRotO = this.yRot = this.passenger.yRot;
            this.xRotO = this.xRot = this.passenger.xRot;
            Player player = (Player)this.passenger;
            ((EntityAccessor)player).setFallDistance(0.0f);
        } else {
            this.footSize = this.rideFootSize - 0.5f;
            super.updateAI();
        }
    }

    public void onGround() {
        if (this.onGround) {
            this.jumpsRemaining = this.getJumpMaxAmount();
        }
    }
}

