/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.phyg;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelQuadruped;

@Environment(value=EnvType.CLIENT)
public class ModelPhyg
extends ModelQuadruped {
    public Cube nose;
    public static Cube leftWingInner;
    public static Cube leftWingOuter;
    public static Cube rightWingInner;
    public static Cube rightWingOuter;

    public ModelPhyg() {
        this(0.0f);
    }

    public ModelPhyg(float f) {
        super(6, f);
        this.head = new Cube(0, 0, 128, 64);
        this.head.addBox(-4.0f, -4.0f, -8.0f, 8, 8, 8, f);
        this.head.setRotationPoint(0.0f, 12.0f, -6.0f);
        this.body = new Cube(28, 8, 128, 64);
        this.body.addBox(-5.0f, -10.0f, -7.0f, 10, 16, 8, f);
        this.body.setRotationPoint(0.0f, 11.0f, 2.0f);
        this.leg1 = new Cube(0, 16, 128, 64);
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg1.setRotationPoint(-3.0f, 18.0f, 7.0f);
        this.leg2 = new Cube(0, 16, 128, 64);
        this.leg2.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg2.setRotationPoint(3.0f, 18.0f, 7.0f);
        this.leg3 = new Cube(0, 16, 128, 64);
        this.leg3.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg3.setRotationPoint(-3.0f, 18.0f, -5.0f);
        this.leg4 = new Cube(0, 16, 128, 64);
        this.leg4.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg4.setRotationPoint(3.0f, 18.0f, -5.0f);
        this.nose = new Cube(16, 16, 128, 64);
        this.nose.addBox(-2.0f, 0.0f, -9.0f, 4, 3, 1);
        this.nose.setRotationPoint(0.0f, 12.0f, -6.0f);
        leftWingInner = new Cube(0, 32, 128, 64);
        leftWingInner.addBox(-1.0f, -8.0f, -4.0f, 2, 16, 8, 0.0f);
        leftWingOuter = new Cube(20, 32, 128, 64);
        leftWingOuter.addBox(-1.0f, -8.0f, -4.0f, 2, 16, 8, 0.0f);
        rightWingInner = new Cube(0, 32, 128, 64);
        rightWingInner.addBox(-1.0f, -8.0f, -4.0f, 2, 16, 8, 0.0f);
        rightWingOuter = new Cube(40, 32, 128, 64);
        rightWingOuter.addBox(-1.0f, -8.0f, -4.0f, 2, 16, 8, 0.0f);
        ModelPhyg.rightWingOuter.yRot = (float)Math.PI;
    }

    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.render(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.nose.render(scale);
        leftWingInner.render(scale);
        rightWingInner.render(scale);
        leftWingOuter.render(scale);
        rightWingOuter.render(scale);
    }

    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.nose.xRot = headPitch / 57.29578f;
        this.nose.yRot = headYaw / 57.29578f;
    }
}

