/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.boss.valkyrie.queen;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamport.aether.AetherMod;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.entity.boss.AetherBossList;
import teamport.aether.entity.boss.MobBoss;
import teamport.aether.entity.projectile.ProjectileElementLightning;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.items.AetherItems;
import teamport.aether.world.feature.util.WorldFeaturePoint;
import teamport.aether.world.feature.util.map.DungeonMap;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class MobBossValkyrie
extends MobBoss {
    public boolean isSwinging;
    public boolean isReadyToDuel;
    public boolean isAgro;
    public int teleportTimer;
    public int chatTime;
    public float sinage;
    public int attackStrength;

    public MobBossValkyrie(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"boss_valkyrie");
        this.setSize(0.8f, 2.0f);
        this.scoreValue = 50000;
        this.mobDrops.add(new WeightedRandomLootObject(AetherItems.TOOL_SWORD_HOLY.getDefaultStack(), 1));
        this.moveSpeed = 0.5f;
        this.attackStrength = 10;
        this.footSize = 1.5f;
        this.chatColor = (byte)(TextFormatting.LIGHT_GRAY.id & 0xFF);
        this.canBreatheUnderwater();
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public void jump() {
        this.yd = 0.72;
    }

    public void tick() {
        if (!this.isAgro) {
            this.moveSpeed = 0.0f;
        }
        this.yo = this.yd;
        super.tick();
        if (!this.onGround && this.target != null && this.yo >= 0.0 && this.yd < 0.0 && this.distanceTo(this.target) <= 16.0f && this.canEntityBeSeen(this.target)) {
            double a = this.target.x - this.x;
            double b = this.target.z - this.z;
            double angle = Math.atan2(a, b);
            this.xd = Math.sin(angle) * 0.25;
            this.zd = Math.cos(angle) * 0.25;
        }
        if (!this.onGround && this.yd < 0.0) {
            this.yd += (double)0.055f;
            if (this.yd < (double)-0.275f) {
                this.yd = -0.275f;
            }
        }
        float f = this.moveSpeed = this.target == null ? 0.5f : 1.0f;
        if (!this.world.getDifficulty().canHostileMobsSpawn() && this.target != null) {
            this.target = null;
        }
        if (this.isSwinging) {
            this.prevSwingProgress += 0.15f;
            this.swingProgress += 0.15f;
            if (this.prevSwingProgress > 1.0f || this.swingProgress > 1.0f) {
                this.isSwinging = false;
                this.prevSwingProgress = 0.0f;
                this.swingProgress = 0.0f;
            }
        }
        this.sinage = !this.onGround ? (this.sinage += 0.75f) : (this.sinage += 0.15f);
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
        }
    }

    public void updateAI() {
        super.updateAI();
        ++this.teleportTimer;
        this.target = this.findPlayerToAttack();
        if (this.target == null && this.isAgro) {
            this.isAgro = false;
            this.returnToOriginalState();
        }
        if (this.isReadyToDuel && this.target != null) {
            if (this.teleportTimer >= 125) {
                this.teleport(this.target.x, this.target.y, this.target.z, 8);
                this.remainingFireTicks = 0;
            } else if (this.teleportTimer % 5 == 0 && !this.canEntityBeSeen(this.target)) {
                this.teleportTimer += 50;
            }
        } else {
            this.teleportTimer = this.random.nextInt(40);
        }
        if (this.onGround && this.teleportTimer % 10 == 0) {
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
    }

    public boolean interact(@NotNull Player entityplayer) {
        if (this.chatTime > 0 || this.isReadyToDuel && this.target == entityplayer) {
            return false;
        }
        this.lookAt((Entity)entityplayer, 180.0f, 180.0f);
        this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.talk", 1.0f, 0.75f);
        if (!this.world.getDifficulty().canHostileMobsSpawn()) {
            entityplayer.sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey("aether.entity.boss_valkyrie.peaceful"));
            this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.laugh", 1.0f, 0.75f);
            this.chatTime = 40;
            return true;
        }
        if (this.isReadyToDuel) {
            entityplayer.sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey("aether.entity.boss_valkyrie.duel"));
            this.chatTime = 40;
            return true;
        }
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == AetherItems.MEDAL_VICTORY.id && itemstack.stackSize >= 10) {
            itemstack.stackSize -= 10;
            if (itemstack.stackSize <= 0) {
                entityplayer.destroyCurrentEquippedItem();
            }
            entityplayer.sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey("aether.entity.boss_valkyrie.duel_start"));
            this.isReadyToDuel = true;
        } else {
            entityplayer.sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey("aether.entity.boss_valkyrie.condition"));
        }
        this.chatTime = 40;
        return true;
    }

    public void causeFallDamage(float distance) {
    }

    public void spawnInit() {
        this.teleportTimer = this.random.nextInt(125);
    }

    public Entity findPlayerToAttack() {
        if (!this.isReadyToDuel || !this.isAgro) {
            return null;
        }
        Entity newTarget = this.world.players.stream().filter(Objects::nonNull).filter(player -> player.getGamemode().areMobsHostile()).filter(player -> player.distanceTo((Entity)this) <= 80.0f).filter(arg_0 -> ((MobBossValkyrie)this).canEntityBeSeen(arg_0)).min(Comparator.comparingDouble(arg_0 -> ((MobBossValkyrie)this).distanceTo(arg_0))).orElse(null);
        boolean currTargetIsBetter = this.target != null && this.target.isAlive() && this.target.distanceToSqr((Entity)this) <= 6400.0 && (newTarget == null || newTarget.distanceTo((Entity)this) < this.target.distanceTo((Entity)this));
        Entity entity = newTarget = currTargetIsBetter ? this.target : newTarget;
        if (newTarget instanceof AetherBossList) {
            ((AetherBossList)newTarget).aether$TryAddBossList((Mob)this);
        }
        return newTarget;
    }

    @Override
    public void onDeath(Entity entityKilledBy) {
        this.world.players.stream().filter(player -> player.distanceTo((Entity)this) < 32.0f).forEach(player -> {
            this.world.playSoundEffect((Entity)player, SoundCategory.WORLD_SOUNDS, player.x, player.y, player.z, "aether:achievement.silver", 0.5f, 1.0f);
            player.triggerAchievement((Stat)AetherAchievements.SILVER);
            player.sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey("aether.entity.boss_valkyrie.dies"));
        });
        super.onDeath(entityKilledBy);
    }

    public void teleport(double x, double y, double z, int rad) {
        int ax = this.random.nextInt(rad + 1) * (this.random.nextInt(2) * 2 - 1);
        int ay = this.random.nextInt(rad / 2) * (this.random.nextInt(2) * 2 - 1);
        int az = (rad - Math.abs(ax)) * (this.random.nextInt(2) * 2 - 1);
        int newX = (int)Math.floor(x += (double)ax);
        int newY = (int)Math.floor(y += (double)ay);
        int newZ = (int)Math.floor(z += (double)az);
        boolean flag = false;
        if (this.returnPoint == null) {
            AetherMod.LOGGER.info("Queen Valk at {}, {}, {} has no return point!", new Object[]{x, y, z});
            return;
        }
        WorldFeaturePoint p1 = new WorldFeaturePoint(this.returnPoint.x - 9, this.returnPoint.y - 3, this.returnPoint.z - 16);
        for (int q = 0; q < 128 && !flag; ++q) {
            int ix = newX + (this.random.nextInt(6) - this.random.nextInt(6));
            int iy = (int)this.y;
            int iz = newZ + (this.random.nextInt(6) - this.random.nextInt(6));
            if (iy < 0 || iy >= this.world.getHeightBlocks() || !this.isAirySpace(ix, iy, iz) || !this.isAirySpace(ix, iy + 1, iz) || this.isAirySpace(ix, iy - 1, iz) || ix < p1.x || ix > p1.x + 16 || iy < p1.y || iy > p1.y + 16 || iz < p1.z || iz > p1.z + 16) continue;
            newX = ix;
            newY = iy;
            newZ = iz;
            flag = true;
        }
        if (!flag) {
            this.teleportFailed();
        } else {
            if (!EnvironmentHelper.isServerEnvironment()) {
                ParticleHelper.spawnParticle(this.world, "explode", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
                ParticleHelper.spawnParticle(this.world, "smoke", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
                ParticleHelper.spawnParticle(this.world, "largesmoke", this.x, this.y + 1.0, this.z, 0.0, 0.0, 0.0, 0);
            }
            this.setPos((double)newX + 0.5, newY, (double)newZ + 0.5);
            this.world.playSoundAtEntity(null, (Entity)this, "mob.ghast.fireball", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
            this.moveForward = 0.0f;
            this.moveStrafing = 0.0f;
            this.isJumping = false;
            this.xRot = 0.0f;
            this.yRot = 0.0f;
            this.setPathToEntity(null);
            this.yBodyRot = this.random.nextFloat() * 360.0f;
            this.teleportTimer = this.random.nextInt(40);
        }
    }

    public boolean isAirySpace(int x, int y, int z) {
        int p = this.world.getBlockId(x, y, z);
        Block block = this.world.getBlock(x, y, z);
        return p == 0 || Blocks.blocksList[p] == null || Blocks.blocksList[p].getCollisionBoundingBoxFromPool((WorldSource)this.world, x, y, z) == null || block.getMaterial() == Material.water;
    }

    public void swingArm() {
        if (!this.isSwinging) {
            this.isSwinging = true;
            this.prevSwingProgress = 0.0f;
            this.swingProgress = 0.0f;
        }
    }

    public void teleportFailed() {
        this.teleportTimer -= this.random.nextInt(40) + 40;
        if (this.y <= 0.0) {
            this.teleportTimer = 100;
        }
    }

    public boolean canSpawnHere() {
        int k;
        int j;
        int i = MathHelper.floor((double)this.x);
        return this.world.getFullBlockLightValue(i, j = MathHelper.floor((double)this.bb.minY), k = MathHelper.floor((double)this.z)) > 8 && this.world.getIsAnySolidGround(this.bb) && this.world.getCollidingSolidBlockBoundingBoxes((Entity)this, this.bb).isEmpty() && !this.world.getIsAnyLiquid(this.bb);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("teleportTimer", (short)this.teleportTimer);
        tag.putBoolean("isReadyToDuel", this.isReadyToDuel);
        tag.putBoolean("isAgro", this.isAgro);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.teleportTimer = tag.getShort("teleportTimer");
        this.isReadyToDuel = tag.getBoolean("isReadyToDuel");
        this.isAgro = tag.getBoolean("isAgro");
    }

    @Override
    public boolean canFight() {
        return this.isAlive() && this.isReadyToDuel;
    }

    public boolean hurt(Entity attacker, int damage, DamageType type) {
        assert (this.world != null);
        if (attacker == null && type == null && damage == 100) {
            this.setHealthRaw(0);
            this.playDeathSound();
            this.onDeath(null);
            return true;
        }
        if (!this.isReadyToDuel) {
            if (!(attacker instanceof Player) || this.chatTime > 0) {
                return false;
            }
            if (!this.world.getDifficulty().canHostileMobsSpawn()) {
                ((Player)attacker).sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey("aether.entity.boss_valkyrie.weakling"));
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.laugh", 1.0f, 0.75f);
            } else {
                String message = this.random.nextInt(2) == 0 ? "aether.entity.boss_valkyrie.fight_weaklings" : "aether.entity.boss_valkyrie.collect_medals";
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.talk", 1.0f, 0.75f);
                ((Player)attacker).sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey(message));
            }
            this.chatTime = 40;
            return false;
        }
        if (this.target == null && attacker instanceof Player) {
            DungeonMap.runWithDungeon(this.dungeonID, d -> d.lock(this, this.world));
            ((Player)attacker).sendTranslatedChatMessage(AetherMod.TRANSLATOR.translateKey("aether.entity.boss_valkyrie.target"));
            ((AetherBossList)attacker).aether$TryAddBossList((Mob)this);
            this.chatTime = 40;
            this.target = attacker;
            this.isAgro = true;
            this.world.players.stream().filter(player -> player.distanceTo((Entity)this) < 32.0f).forEach(player -> ((AetherBossList)player).aether$TryAddBossList((Mob)this));
        } else {
            this.teleportTimer += 40;
        }
        return super.hurt(attacker, damage, type);
    }

    public void attackEntity(@NotNull Entity entity, float distance) {
        if (this.getHealth() < this.getMaxHealth() / 2 && distance > 5.0f) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    ProjectileElementLightning elementLightning = new ProjectileElementLightning(this.world, (Mob)this);
                    elementLightning.setHeading(this.world.rand.nextDouble(), this.getLookAngle().y + 5.0, this.world.rand.nextDouble(), 0.5f, 0.0f);
                    this.world.playSoundAtEntity(null, (Entity)this, "mob.ghast.fireball", this.getSoundVolume(), (this.random.nextFloat() + this.random.nextFloat()) * 1.2f + 1.0f);
                    this.world.entityJoinedWorld((Entity)elementLightning);
                }
                this.attackTime = 50;
            }
            this.yRot = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
        if (this.attackTime <= 0 && distance < 2.75f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            Player target;
            this.attackTime = 20;
            this.swingArm();
            entity.hurt((Entity)this, this.attackStrength, DamageType.COMBAT);
            if (this.target != null && entity == this.target && entity instanceof Player && !(target = (Player)entity).isAlive() && this.chatTime <= 0) {
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.valkyrie.laugh", 1.0f, 0.75f);
            }
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "aether:mob.valkyrie.hurt";
    }

    public String getDeathSound() {
        return "aether:mob.valkyrie.death";
    }

    public void playHurtSound() {
        this.world.playSoundAtEntity(null, (Entity)this, this.getHurtSound(), 0.75f, 0.75f);
    }

    public void playDeathSound() {
        this.world.playSoundAtEntity(null, (Entity)this, this.getDeathSound(), 1.0f, 0.75f);
    }

    public int getMaxHealth() {
        return 400;
    }

    public ItemStack getHeldItem() {
        return new ItemStack(AetherItems.TOOL_SWORD_HOLY, 1);
    }
}

