/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.entity.boss.sunspirit.MobBossSunspirit;
import teamport.aether.entity.monster.fireminion.MobFireMinion;
import teamport.aether.entity.projectile.AetherProjectileDeathMessages;
import teamport.aether.entity.projectile.ProjectileElementBase;
import teamport.aether.helper.ParticleHelper;

public class ProjectileElementFire
extends ProjectileElementBase
implements AetherProjectileDeathMessages<ProjectileElementFire> {
    public String[] particles = new String[]{"explode", "flame", "lava"};

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner, @Nullable CompoundTag compoundTag) {
        return ProjectileElementFire.getEntity(ProjectileElementFire.class, world, x, y, z, meta, hasVelocity, xd, yd, zd, owner, compoundTag);
    }

    public ProjectileElementFire(World world) {
        super(world);
        this.initProjectile();
        this.projectileSpeed = 0.25f;
    }

    public ProjectileElementFire(World world, Mob owner) {
        super(world, owner);
        this.initProjectile();
        this.projectileSpeed = 0.25f;
    }

    @Override
    public void tick() {
        for (int j = 0; j < 1; ++j) {
            ParticleHelper.spawnParticle(this.world, "flame", this.x, this.y + 0.5, this.z, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), 0.0, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), 0);
        }
        super.tick();
    }

    @Override
    public void doExplosion() {
        for (int particle = 0; particle < 16; ++particle) {
            double XParticle = this.x + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            double YParticle = this.y + 0.5 + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            double ZParticle = this.z + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat() * 0.375;
            ParticleHelper.spawnParticle(this.world, this.particles[this.world.rand.nextInt(this.particles.length)], XParticle, YParticle, ZParticle, 0.0, 0.0, 0.0, 0);
        }
        this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, this.x, this.y, this.z, "mob.ghast.fireball", 0.25f, (1.3f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public void onHit(HitResult hitResult) {
        if (!(this.world.isClientSide || hitResult.entity instanceof MobBossSunspirit || hitResult.entity instanceof ProjectileElementBase || hitResult.entity instanceof MobFireMinion || !(hitResult.entity instanceof Mob))) {
            hitResult.entity.hurt((Entity)this.owner, this.damage, DamageType.FIRE);
            hitResult.entity.maxFireTicks = 200;
            hitResult.entity.remainingFireTicks = 200;
            this.remove();
            return;
        }
        super.onHit(hitResult);
    }
}

