/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.helper;

import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;

public class MetadataHelper {
    public static final byte MASK_DIRECTION = 3;

    public static int getMetadataFromDyeAndDirection(DyeColor dyeColor, Direction direction) {
        return dyeColor.blockMeta << 4 | direction.getHorizontalIndex();
    }

    public static int getMetadataFromDyeAndLower(DyeColor dyeColor, int lowerBits) {
        return dyeColor.blockMeta << 4 | lowerBits;
    }

    public static int maskDirectionHorizontal(int metadata, Direction direction) {
        return metadata & 0xFFFFFFFC | direction.getHorizontalIndex();
    }

    public static int maskDirectionHorizontal(int metadata, int direction) {
        return metadata & 0xFFFFFFFC | direction;
    }

    public static int setMetadataTrapdoor(DyeColor dyeColor, boolean isUpper, boolean isOpen, Direction direction) {
        int upper = isUpper ? 1 : 0;
        int open = isOpen ? 1 : 0;
        int metadata = dyeColor.blockMeta << 4;
        metadata |= upper << 3;
        return (metadata |= open << 2) | MetadataHelper.getTrapDoorMetaForDirection(direction.getOpposite());
    }

    public static int setMetadataTrapdoor(boolean isUpper, boolean isOpen, Direction direction) {
        int upper = isUpper ? 1 : 0;
        int open = isOpen ? 1 : 0;
        int metadata = 0;
        metadata |= upper << 3;
        return (metadata |= open << 2) | MetadataHelper.getTrapDoorMetaForDirection(direction.getOpposite());
    }

    public static int getMetadataStairs(DyeColor dyeColor, boolean isUpper, Direction direction) {
        int upper = isUpper ? 1 : 0;
        int metadata = dyeColor.blockMeta << 4;
        return (metadata |= upper << 3) | MetadataHelper.getStairMetadataFromDirection(direction);
    }

    public static int getMetadataStairs(boolean isUpper, Direction direction) {
        int upper = isUpper ? 1 : 0;
        int metadata = 0;
        return (metadata |= upper << 3) | MetadataHelper.getStairMetadataFromDirection(direction);
    }

    public static int getTrapDoorMetaForDirection(Direction direction) {
        switch (direction) {
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
            case SOUTH: {
                return 0;
            }
        }
        return 1;
    }

    public static Direction getTrapDoorDirectionForMeta(int metadata) {
        switch (metadata) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.NORTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NONE;
    }

    public static int getTorchMetadataFromDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return 3;
            }
            case EAST: {
                return 2;
            }
            case SOUTH: {
                return 4;
            }
            case WEST: {
                return 1;
            }
            case DOWN: {
                return 5;
            }
            case UP: {
                return 6;
            }
        }
        return 0;
    }

    public static Direction getTorchDirectionFromMetadata(int metadata) {
        switch (metadata) {
            case 3: {
                return Direction.NORTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 4: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.WEST;
            }
            case 5: {
                return Direction.DOWN;
            }
            case 6: {
                return Direction.UP;
            }
        }
        return Direction.NONE;
    }

    public static int getStairMetadataFromDirection(Direction direction) {
        switch (direction) {
            case EAST: {
                return 0;
            }
            case WEST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
        }
        return 3;
    }

    public static Direction getStairDirectionFromMetadata(int metadata) {
        switch (metadata) {
            case 0: {
                return Direction.EAST;
            }
            case 1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.SOUTH;
            }
        }
        return Direction.NORTH;
    }
}

