/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.dimension.bumpToOverworld;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketSetRiding;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.AetherMod;
import teamport.aether.world.AetherDimension;

@Mixin(value={PlayerServer.class}, remap=false)
public abstract class MPBumpToOverworldMixin
extends Player {
    @Shadow
    @NotNull
    public abstract String getDisplayName();

    public MPBumpToOverworldMixin(World world) {
        super(world);
    }

    @Inject(method={"onUpdateEntity"}, at={@At(value="HEAD")})
    public void bumpPlayerToOverworld(CallbackInfo ci) {
        if (this.dimension == AetherDimension.AetherDimensionID && this.y < (double)(this.world.worldType.getMinY() - 10)) {
            AetherMod.LOGGER.info("Sending {} to overworld", (Object)this.getDisplayName());
            MinecraftServer server = MinecraftServer.getInstance();
            CompoundTag passengerNBT = null;
            CompoundTag vehicleNBT = null;
            if (this.getPassenger() != null) {
                Entity p = this.getPassenger();
                this.ejectRider();
                passengerNBT = new CompoundTag();
                p.save(passengerNBT);
                p.remove();
            }
            if (this.isPassenger() && this.vehicle != null) {
                vehicleNBT = new CompoundTag();
                ((Entity)this.vehicle).save(vehicleNBT);
                this.vehicle.ejectRider();
            }
            float scale = Dimension.getCoordScale((Dimension)AetherDimension.AETHER, (Dimension)Dimension.OVERWORLD);
            this.moveTo(this.x * (double)scale, 270.0, this.z * (double)scale, this.yRot, this.xRot);
            PlayerServer player = (PlayerServer)PlayerServer.class.cast((Object)this);
            WorldServer targetWorld = server.getDimensionWorld(Dimension.OVERWORLD.id);
            server.playerList.sendPlayerToOtherDimension(player, Dimension.OVERWORLD.id, DyeColor.BLUE, false);
            if (passengerNBT != null) {
                Entity p = EntityDispatcher.createEntityFromNBT((CompoundTag)passengerNBT, (World)targetWorld);
                p.load(passengerNBT);
                p.moveTo(this.x, this.y, this.z, 0.0f, 0.0f);
                targetWorld.entityJoinedWorld(p);
                p.startRiding((IVehicle)this);
                player.playerNetServerHandler.sendPacket((Packet)new PacketSetRiding(p, (Entity)player));
            }
            if (vehicleNBT != null) {
                Entity v = EntityDispatcher.createEntityFromNBT((CompoundTag)vehicleNBT, (World)targetWorld);
                v.moveTo(this.x, this.y, this.z, 0.0f, 0.0f);
                targetWorld.entityJoinedWorld(v);
                this.startRiding((IVehicle)v);
            }
        }
    }
}

