/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.fix;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeInteger;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.commands.CommandHeal;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.util.helper.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandHeal.class}, remap=false, priority=0)
public class CommandHealMixin {
    @Unique
    private static int heal(CommandContext<?> c) {
        List targets;
        EntitySelector entitySelector = (EntitySelector)c.getArgument("target", EntitySelector.class);
        int amount = (Integer)c.getArgument("amount", Integer.class);
        try {
            targets = entitySelector.get((CommandSource)c.getSource()).stream().filter(e -> e instanceof Mob).map(e -> (Mob)e).collect(Collectors.toList());
        }
        catch (CommandSyntaxException e2) {
            throw new RuntimeException(e2);
        }
        int entitiesAffected = 0;
        for (Mob target : targets) {
            int maxHealth = target.getMaxHealth();
            int originalHealth = target.getHealth();
            target.setHealthRaw(MathHelper.clamp((int)(target.getHealth() + amount), (int)0, (int)maxHealth));
            if (target.getHealth() == originalHealth) continue;
            ++entitiesAffected;
        }
        ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.heal.success_" + (entitiesAffected == 1 ? "single" : "multiple"), new Object[]{entitiesAffected});
        return entitiesAffected;
    }

    @Inject(method={"register"}, at={@At(value="HEAD")}, cancellable=true)
    public void register(CommandDispatcher<CommandSource> dispatcher, CallbackInfo ci) {
        ci.cancel();
        ArgumentBuilderLiteral commandHeal = (ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"heal").requires(c -> ((CommandSource)c).hasAdmin())).then(ArgumentBuilderRequired.argument((String)"target", (ArgumentType)ArgumentTypeEntity.entities()).then(ArgumentBuilderRequired.argument((String)"amount", (ArgumentType)ArgumentTypeInteger.integer((int)0, (int)32768)).executes(CommandHealMixin::heal)));
        dispatcher.register(commandHeal);
    }
}

