/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.handler.PacketHandlerServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import teamport.aether.items.itemtool.AetherToolMaterial;

@Environment(value=EnvType.SERVER)
@Mixin(value={PacketHandlerServer.class}, remap=false)
public class PacketHandlerServerValkToolsReachMixin {
    @Shadow
    private PlayerServer playerEntity;

    @ModifyVariable(method={"handleBlockDig"}, at=@At(value="STORE"), name={"playerDist"})
    private double fixReachDistanceForBlocks(double original) {
        double playerReach;
        double actualMaxDist;
        if (AetherToolMaterial.isHoldingValkyrieTool((Player)this.playerEntity) && original < (actualMaxDist = Math.ceil(Math.pow((playerReach = (double)(this.playerEntity.gamemode.getBlockReachDistance() + 6.0f)) + (double)0.6f, 2.0)))) {
            return 0.0;
        }
        return original;
    }

    @Redirect(method={"handleUseEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/entity/player/PlayerServer;distanceToSqr(Lnet/minecraft/core/entity/Entity;)D"))
    private double fixReachDistanceForEntities(PlayerServer player, Entity entity) {
        double playerReach;
        double actualMaxDist;
        double dist = player.distanceToSqr(entity);
        if (AetherToolMaterial.isHoldingValkyrieTool((Player)player) && dist < (actualMaxDist = Math.ceil(Math.pow((playerReach = (double)(this.playerEntity.gamemode.getEntityReachDistance() + 6.0f)) + (double)0.6f, 2.0)))) {
            return 0.0;
        }
        return dist;
    }
}

