/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models.skyroot;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.block.model.BlockModelDoor;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import teamport.aether.blocks.skyroot.BlockLogicPaintedDoor;

@Environment(value=EnvType.CLIENT)
public class BlockModelPaintedSkyrootDoor<T extends BlockLogicPaintedDoor>
extends BlockModelDoor<T> {
    public static final IconCoordinate[] doorBottomTextures = new IconCoordinate[16];
    public static final IconCoordinate[] doorTopTextures = new IconCoordinate[16];
    public static final IconCoordinate[] frameTopTextures = new IconCoordinate[16];
    private final boolean isTop;

    public BlockModelPaintedSkyrootDoor(Block<T> block, boolean isTop) {
        super(block);
        this.isTop = isTop;
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4 & 0xF;
        if (side.getAxis() == Axis.Y) {
            return frameTopTextures[color];
        }
        return this.isTop ? doorTopTextures[color] : doorBottomTextures[color];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelPaintedSkyrootDoor.doorTopTextures[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/door/skyroot_" + c.colorID + "/top"));
            BlockModelPaintedSkyrootDoor.doorBottomTextures[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/door/skyroot_" + c.colorID + "/bottom"));
            BlockModelPaintedSkyrootDoor.frameTopTextures[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/door/skyroot_" + c.colorID + "/frame_top"));
        }
    }
}

