/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

@Environment(value=EnvType.CLIENT)
public class ParticleLightningKnife
extends Particle {
    public float originalScale;

    public ParticleLightningKnife(World world, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z, xd, yd, zd);
        this.xd = this.xd * 0.01 + xd;
        this.yd = this.yd * 0.01 + yd;
        this.zd = this.zd * 0.01 + zd;
        this.x += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.y += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.z += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.originalScale = this.size;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.noPhysics = true;
        this.tex = TextureRegistry.getTexture((String)"aether:particle/lightiningknife");
    }

    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float s = ((float)this.age + partialTick) / (float)this.lifetime;
        this.size = this.originalScale * (1.0f - s * s * 0.5f);
        super.render(t, partialTick, xOff, yOff, zOff, xa, ya, za, xa2, za2);
    }

    public float getBrightness(float partialTick) {
        float decay = MathHelper.clamp((float)(((float)this.age + partialTick) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        return super.getBrightness(partialTick) * decay + (1.0f - decay);
    }

    public int getLightmapCoord(float partialTick) {
        return LightmapHelper.setBlocklightValue((int)super.getLightmapCoord(partialTick), (int)15);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

